/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.Node;
import java.util.Arrays;
import java.util.Collection;

public class ClusterMetadata {
    private final Collection<Node> nodes;

    public static Builder builder() {
        return new Builder();
    }

    public ClusterMetadata(Collection<Node> nodes) {
        this.nodes = nodes;
    }

    public Collection<Node> nodes() {
        return this.nodes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodes", this.nodes).toString();
    }

    public static class Builder
    implements io.atomix.utils.Builder<ClusterMetadata> {
        protected Collection<Node> nodes;

        public Builder withNodes(Node ... bootstrapNodes) {
            return this.withNodes(Arrays.asList((Object[])Preconditions.checkNotNull((Object)bootstrapNodes)));
        }

        public Builder withNodes(Collection<Node> nodes) {
            this.nodes = (Collection)Preconditions.checkNotNull(nodes, (Object)"nodes cannot be null");
            return this;
        }

        public ClusterMetadata build() {
            return new ClusterMetadata(this.nodes);
        }
    }
}

