/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster;

import io.atomix.cluster.NodeConfig;
import io.atomix.utils.Config;
import io.atomix.utils.net.Address;
import io.atomix.utils.net.MalformedAddressException;
import java.util.ArrayList;
import java.util.Collection;

public class ClusterConfig
implements Config {
    private static final String DEFAULT_CLUSTER_NAME = "atomix";
    private static final String DEFAULT_MULTICAST_IP = "230.0.0.1";
    private static final int DEFAULT_MULTICAST_PORT = 54321;
    private String name = "atomix";
    private NodeConfig localNode;
    private Collection<NodeConfig> nodes = new ArrayList<NodeConfig>();
    private boolean multicastEnabled = false;
    private Address multicastAddress;

    public ClusterConfig() {
        try {
            this.multicastAddress = Address.from((String)DEFAULT_MULTICAST_IP, (int)54321);
        }
        catch (MalformedAddressException e) {
            this.multicastAddress = Address.from((int)54321);
        }
    }

    public String getName() {
        return this.name;
    }

    public ClusterConfig setName(String name) {
        this.name = name;
        return this;
    }

    public NodeConfig getLocalNode() {
        return this.localNode;
    }

    public ClusterConfig setLocalNode(NodeConfig localNode) {
        this.localNode = localNode;
        return this;
    }

    public Collection<NodeConfig> getNodes() {
        return this.nodes;
    }

    public ClusterConfig setNodes(Collection<NodeConfig> nodes) {
        this.nodes = nodes;
        return this;
    }

    public boolean isMulticastEnabled() {
        return this.multicastEnabled;
    }

    public ClusterConfig setMulticastEnabled(boolean multicastEnabled) {
        this.multicastEnabled = multicastEnabled;
        return this;
    }

    public Address getMulticastAddress() {
        return this.multicastAddress;
    }

    public ClusterConfig setMulticastAddress(Address multicastAddress) {
        this.multicastAddress = multicastAddress;
        return this;
    }
}

