/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.agent;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.NodeConfig;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.discovery.BootstrapDiscoveryConfig;
import io.atomix.cluster.discovery.MulticastDiscoveryConfig;
import io.atomix.cluster.discovery.NodeDiscoveryConfig;
import io.atomix.core.Atomix;
import io.atomix.core.AtomixConfig;
import io.atomix.rest.ManagedRestService;
import io.atomix.rest.RestService;
import io.atomix.utils.net.Address;
import io.atomix.utils.net.MalformedAddressException;
import java.util.Collection;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixAgent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArgumentType nodeArgumentType = (argumentParser, argument, value) -> new NodeConfig().setId((NodeId)AtomixAgent.parseMemberId(value)).setAddress(AtomixAgent.parseAddress(value));
        ArgumentType addressArgumentType = (argumentParser, argument, value) -> Address.from((String)value);
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"AtomixServer").defaultHelp(true).description("Atomix server");
        parser.addArgument(new String[]{"--member", "-m"}).type(String.class).nargs("?").required(false).help("The local member identifier, used in intra-cluster communication.");
        parser.addArgument(new String[]{"--address", "-a"}).type(addressArgumentType).metavar(new String[]{"HOST:PORT"}).nargs("?").required(false).help("The address for the local member. If no address is specified, the first public interface will be used.");
        parser.addArgument(new String[]{"--host"}).type(String.class).nargs("?").required(false).help("The host on which this member runs, used for host-aware partition management.");
        parser.addArgument(new String[]{"--rack"}).type(String.class).nargs("?").required(false).help("The rack on which this member runs, used for rack-aware partition management.");
        parser.addArgument(new String[]{"--zone"}).type(String.class).nargs("?").required(false).help("The zone in which this member runs, used for zone-aware partition management.");
        parser.addArgument(new String[]{"--config", "-c"}).metavar(new String[]{"FILE|JSON|YAML"}).required(false).help("The Atomix configuration. Can be specified as a file path or JSON/YAML string.");
        parser.addArgument(new String[]{"--bootstrap", "-b"}).nargs("*").type(nodeArgumentType).metavar(new String[]{"NAME@HOST:PORT"}).required(false).help("The set of core members, if any. When bootstrapping a new cluster, if the local member is a core member then it should be present in the core configuration as well.");
        parser.addArgument(new String[]{"--multicast"}).action((ArgumentAction)new StoreTrueArgumentAction()).setDefault((Object)false).help("Enables multicast discovery. Note that the network must support multicast for this feature to work.");
        parser.addArgument(new String[]{"--multicast-group"}).type(String.class).metavar(new String[]{"IP"}).help("Sets the multicast group. Defaults to 230.0.0.1");
        parser.addArgument(new String[]{"--multicast-port"}).type(Integer.class).metavar(new String[]{"PORT"}).help("Sets the multicast port. Defaults to 54321");
        parser.addArgument(new String[]{"--http-port", "-p"}).type(Integer.class).metavar(new String[]{"PORT"}).required(false).setDefault((Object)5678).help("Sets the port on which to run the HTTP server. Defaults to 5678");
        Namespace namespace = null;
        try {
            namespace = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        String configString = (String)namespace.get("config");
        String memberId = namespace.getString("member");
        Address address = (Address)namespace.get("address");
        String host = namespace.getString("host");
        String rack = namespace.getString("rack");
        String zone = namespace.getString("zone");
        List bootstrap = namespace.getList("bootstrap");
        boolean multicastEnabled = namespace.getBoolean("multicast");
        String multicastGroup = (String)namespace.get("multicast_group");
        Integer multicastPort = (Integer)namespace.get("multicast_port");
        Integer httpPort = namespace.getInt("http_port");
        AtomixConfig config = configString != null ? Atomix.config((String)configString) : Atomix.config();
        if (memberId != null) {
            config.getClusterConfig().getNodeConfig().setId(memberId);
        }
        if (address != null) {
            config.getClusterConfig().getNodeConfig().setAddress(address);
        }
        if (host != null) {
            config.getClusterConfig().getNodeConfig().setHost(host);
        }
        if (rack != null) {
            config.getClusterConfig().getNodeConfig().setRack(rack);
        }
        if (zone != null) {
            config.getClusterConfig().getNodeConfig().setZone(zone);
        }
        if (bootstrap != null && !bootstrap.isEmpty()) {
            config.getClusterConfig().setDiscoveryConfig((NodeDiscoveryConfig)new BootstrapDiscoveryConfig().setNodes((Collection)bootstrap));
        }
        if (multicastEnabled) {
            config.getClusterConfig().getMulticastConfig().setEnabled(true);
            if (multicastGroup != null) {
                config.getClusterConfig().getMulticastConfig().setGroup(multicastGroup);
            }
            if (multicastPort != null) {
                config.getClusterConfig().getMulticastConfig().setPort(multicastPort.intValue());
            }
            if (bootstrap == null || bootstrap.isEmpty()) {
                config.getClusterConfig().setDiscoveryConfig((NodeDiscoveryConfig)new MulticastDiscoveryConfig());
            }
        }
        Atomix atomix = Atomix.builder((AtomixConfig)config).withShutdownHookEnabled().build();
        atomix.start().join();
        LOGGER.info("Atomix listening at {}:{}", (Object)atomix.getMembershipService().getLocalMember().address().host(), (Object)atomix.getMembershipService().getLocalMember().address().port());
        ManagedRestService rest = (ManagedRestService)RestService.builder().withAtomix(atomix).withAddress(Address.from((String)atomix.getMembershipService().getLocalMember().address().host(), (int)httpPort)).build();
        rest.start().join();
        LOGGER.info("HTTP server listening at {}:{}", (Object)atomix.getMembershipService().getLocalMember().address().address().getHostAddress(), (Object)httpPort);
        Class<Atomix> clazz = Atomix.class;
        synchronized (Atomix.class) {
            while (atomix.isRunning()) {
                Atomix.class.wait();
            }
            // ** MonitorExit[var19_20] (shouldn't be in output)
            return;
        }
    }

    static MemberId parseMemberId(String address) {
        int endIndex = address.indexOf(64);
        if (endIndex > 0) {
            return MemberId.from((String)address.substring(0, endIndex));
        }
        return null;
    }

    static Address parseAddress(String address) {
        int startIndex = address.indexOf(64);
        if (startIndex == -1) {
            try {
                return Address.from((String)address);
            }
            catch (MalformedAddressException e) {
                return Address.local();
            }
        }
        return Address.from((String)address.substring(startIndex + 1));
    }
}

