/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.agent;

import io.atomix.cluster.MemberConfig;
import io.atomix.cluster.MemberId;
import io.atomix.core.Atomix;
import io.atomix.core.AtomixConfig;
import io.atomix.rest.ManagedRestService;
import io.atomix.rest.RestService;
import io.atomix.utils.net.Address;
import io.atomix.utils.net.MalformedAddressException;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixAgent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArgumentType memberArgumentType = (argumentParser, argument, value) -> new MemberConfig().setId(AtomixAgent.parseMemberId(value)).setAddress(AtomixAgent.parseAddress(value));
        ArgumentType addressArgumentType = (argumentParser, argument, value) -> Address.from((String)value);
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"AtomixServer").defaultHelp(true).description("Atomix server");
        parser.addArgument(new String[]{"member"}).type(String.class).nargs("?").metavar(new String[]{"NAME@HOST:PORT"}).required(false).help("The member info for the local member. This should be in the format [NAME@]HOST[:PORT]. If no name is provided, the member name will default to the host. If no port is provided, the port will default to 5679.");
        parser.addArgument(new String[]{"--config", "-c"}).metavar(new String[]{"FILE|JSON|YAML"}).required(false).help("The Atomix configuration. Can be specified as a file path or JSON/YAML string.");
        parser.addArgument(new String[]{"--bootstrap", "-b"}).nargs("*").type(memberArgumentType).metavar(new String[]{"NAME@HOST:PORT"}).required(false).help("The set of core members, if any. When bootstrapping a new cluster, if the local member is a core member then it should be present in the core configuration as well.");
        parser.addArgument(new String[]{"--multicast", "-m"}).action((ArgumentAction)new StoreTrueArgumentAction()).setDefault((Object)false).help("Enables multicast discovery. Note that the network must support multicast for this feature to work.");
        parser.addArgument(new String[]{"--multicast-address", "-a"}).type(addressArgumentType).metavar(new String[]{"HOST:PORT"}).help("Sets the multicast discovery address. Defaults to 230.0.0.1:54321");
        parser.addArgument(new String[]{"--http-port", "-p"}).type(Integer.class).metavar(new String[]{"PORT"}).required(false).setDefault((Object)5678).help("Sets the port on which to run the HTTP server. Defaults to 5678");
        Namespace namespace = null;
        try {
            namespace = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        String configString = (String)namespace.get("config");
        String localMemberInfo = (String)namespace.get("member");
        List bootstrapMembers = namespace.getList("bootstrap");
        boolean multicastEnabled = namespace.getBoolean("multicast");
        Address multicastAddress = (Address)namespace.get("multicast_address");
        Integer httpPort = namespace.getInt("http_port");
        AtomixConfig config = configString != null ? Atomix.config((String)configString) : Atomix.config();
        MemberConfig localMember = null;
        if (localMemberInfo != null) {
            MemberId localMemberId = AtomixAgent.parseMemberId(localMemberInfo);
            if (localMemberId != null) {
                localMember = config.getClusterConfig().getMembers().stream().filter(member -> member.getId().equals((Object)localMemberId)).findFirst().orElse(null);
                if (localMember == null && bootstrapMembers != null) {
                    localMember = bootstrapMembers.stream().filter(member -> member.getId().equals((Object)localMemberId)).findFirst().orElse(null);
                }
            } else {
                Address localMemberAddress = AtomixAgent.parseAddress(localMemberInfo);
                localMember = config.getClusterConfig().getMembers().stream().filter(member -> member.getAddress().equals((Object)localMemberAddress)).findFirst().orElse(null);
                if (localMember == null && bootstrapMembers != null) {
                    localMember = bootstrapMembers.stream().filter(member -> member.getAddress().equals((Object)localMemberAddress)).findFirst().orElse(null);
                }
            }
            if (localMember == null) {
                localMember = new MemberConfig().setId(AtomixAgent.parseMemberId(localMemberInfo)).setAddress(AtomixAgent.parseAddress(localMemberInfo));
            }
        }
        if (localMember != null) {
            config.getClusterConfig().setLocalMember(localMember);
        }
        if (bootstrapMembers != null) {
            config.getClusterConfig().setMembers(bootstrapMembers);
        }
        if (multicastEnabled) {
            config.getClusterConfig().setMulticastEnabled(true);
            config.getClusterConfig().setMulticastAddress(multicastAddress);
        }
        Atomix atomix = Atomix.builder((AtomixConfig)config).withShutdownHookEnabled().build();
        atomix.start().join();
        LOGGER.info("Atomix listening at {}:{}", (Object)atomix.getMembershipService().getLocalMember().address().host(), (Object)atomix.getMembershipService().getLocalMember().address().port());
        ManagedRestService rest = (ManagedRestService)RestService.builder().withAtomix(atomix).withAddress(Address.from((String)atomix.getMembershipService().getLocalMember().address().host(), (int)httpPort)).build();
        rest.start().join();
        LOGGER.info("HTTP server listening at {}:{}", (Object)atomix.getMembershipService().getLocalMember().address().address().getHostAddress(), (Object)httpPort);
        Class<Atomix> clazz = Atomix.class;
        synchronized (Atomix.class) {
            while (atomix.isRunning()) {
                Atomix.class.wait();
            }
            // ** MonitorExit[var15_16] (shouldn't be in output)
            return;
        }
    }

    static MemberId parseMemberId(String address) {
        int endIndex = address.indexOf(64);
        if (endIndex > 0) {
            return MemberId.from((String)address.substring(0, endIndex));
        }
        return null;
    }

    static Address parseAddress(String address) {
        int startIndex = address.indexOf(64);
        if (startIndex == -1) {
            try {
                return Address.from((String)address);
            }
            catch (MalformedAddressException e) {
                return Address.local();
            }
        }
        return Address.from((String)address.substring(startIndex + 1));
    }
}

