/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import io.atleon.application.AloStreamCompatibility;
import io.atleon.application.ConfiguredAloStream;
import io.atleon.core.AloStream;
import io.atleon.core.AloStreamConfig;
import io.atleon.core.CompositeAloStream;
import io.atleon.core.SelfConfigurableAloStream;
import io.atleon.spring.AloStreamApplicationListener;
import io.atleon.spring.AutoConfigureStream;
import io.atleon.spring.Contexts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration(proxyBeanMethods=false)
public class AloStreamAutoConfiguration {
    @Bean
    @Conditional(value={AutoConfigureStreamEnabled.class})
    public List<ConfiguredAloStream> autoConfiguredAloStreams(ConfigurableApplicationContext context, List<AloStreamConfig> configs) {
        ArrayList<ConfiguredAloStream> configuredAloStreams = new ArrayList<ConfiguredAloStream>();
        Set uniqueStreams = Collections.newSetFromMap(new IdentityHashMap());
        for (AloStreamConfig config : configs) {
            if (!config.getClass().isAnnotationPresent(AutoConfigureStream.class)) continue;
            AutoConfigureStream annotation = config.getClass().getDeclaredAnnotation(AutoConfigureStream.class);
            AloStream<AloStreamConfig> stream = AloStreamAutoConfiguration.findOrCreateStream(context, config, annotation);
            if (uniqueStreams.add(AloStreamAutoConfiguration.extractStreamInstanceThatShouldBeUnique(stream))) {
                AloStreamApplicationListener<AloStreamConfig> listener = new AloStreamApplicationListener<AloStreamConfig>(stream, config);
                context.addApplicationListener(listener);
                configuredAloStreams.add(listener);
                continue;
            }
            throw new IllegalStateException("Applicable to more than one config: stream=" + stream);
        }
        return configuredAloStreams;
    }

    private static <C extends AloStreamConfig> AloStream<? super C> findOrCreateStream(ConfigurableApplicationContext context, C config, AutoConfigureStream annotation) {
        Class<? extends AloStream> streamType = annotation.value();
        List<SelfConfigurableAloStream> registeredStreams = config instanceof SelfConfigurableAloStream ? Collections.singletonList((SelfConfigurableAloStream)config) : context.getBeansOfType(streamType, false, true).values();
        Optional<AloStream<C>> compatibleStream = AloStreamCompatibility.findSingleCompatibleStream(registeredStreams, config);
        int count = Contexts.parseValue(context, annotation.instanceCountValue()).map(Integer::valueOf).orElseThrow(() -> new IllegalArgumentException("Could not parse instance count: " + annotation.instanceCountValue()));
        if (compatibleStream.isPresent()) {
            AloStream<C> initial = compatibleStream.get();
            return CompositeAloStream.nCopies((int)count, initial, AloStreamAutoConfiguration.newCreator(context, initial.getClass()));
        }
        if (streamType.equals(AloStream.class)) {
            throw new IllegalStateException("Could not find compatible stream for config=" + config);
        }
        if (AloStreamCompatibility.isCompatible(streamType, config)) {
            return CompositeAloStream.nCopies((int)count, AloStreamAutoConfiguration.newCreator(context, streamType));
        }
        throw new IllegalStateException("stream=" + streamType + " is incompatible with config=" + config);
    }

    private static AloStream<?> extractStreamInstanceThatShouldBeUnique(AloStream<? super AloStreamConfig> stream) {
        if (stream instanceof CompositeAloStream) {
            CompositeAloStream compositeAloStream = (CompositeAloStream)stream;
            return compositeAloStream.componentStreamCount() > 0 ? compositeAloStream.componentStreamAt(0) : stream;
        }
        return stream;
    }

    private static <T> Supplier<T> newCreator(ConfigurableApplicationContext context, Class<?> type) {
        return () -> context.getBeanFactory().createBean(type);
    }

    public static final class AutoConfigureStreamEnabled
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !Contexts.isPropertySetToFalse(context, "atleon.stream.configure.auto.enabled");
        }
    }
}

