/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import io.atleon.core.Autostart;
import io.atleon.core.SelfConfigurableAloStream;
import io.atleon.core.StreamPropertyResolver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public abstract class SpringAloStream
extends SelfConfigurableAloStream
implements StreamPropertyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringAloStream.class);
    private final Environment environment;

    protected SpringAloStream(ApplicationContext context) {
        this.environment = context.getEnvironment();
        LOGGER.info("Stream properties for {} configurable under '{}'", (Object)this.name(), (Object)this.specificStreamPropertyNamespace());
    }

    public Autostart autostart() {
        return this.getStreamProperty("autostart", Autostart.class).orElse(super.autostart());
    }

    public String specificStreamPropertyNamespace() {
        return "stream." + this.name().replaceAll("-stream(-\\w?\\d+)?$", "").replace('-', '.');
    }

    public String defaultStreamPropertyNamespace() {
        return "stream.defaults";
    }

    public final <T> Optional<T> getProperty(String key, Class<T> type) {
        return Optional.ofNullable(this.environment.getProperty(key, type));
    }
}

