/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;

public final class ConfigContext {
    private final ApplicationContext applicationContext;

    public ConfigContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T> T getBean(Class<T> clazz) throws BeansException {
        return (T)this.applicationContext.getBean(clazz);
    }

    public <T> T getBean(String name, Class<T> clazz) throws BeansException {
        return (T)this.applicationContext.getBean(name, clazz);
    }

    public <T> T getBean(ResolvableType type) throws BeansException {
        return (T)this.applicationContext.getBeanProvider(type).getObject();
    }

    public Map<String, String> getPropertiesPrefixedBy(String prefix) {
        return (Map)Binder.get((Environment)this.applicationContext.getEnvironment()).bind(prefix, Bindable.mapOf(String.class, String.class)).orElse(Collections.emptyMap());
    }

    public <T> T getProperty(String key, Class<T> clazz, T defaultValue) {
        return (T)this.applicationContext.getEnvironment().getProperty(key, clazz, defaultValue);
    }

    public String getProperty(String key) throws IllegalStateException {
        return this.applicationContext.getEnvironment().getRequiredProperty(key);
    }

    public <T> T getProperty(String key, Class<T> clazz) throws IllegalStateException {
        return (T)this.applicationContext.getEnvironment().getRequiredProperty(key, clazz);
    }

    public Optional<String> findProperty(String key) {
        return Optional.ofNullable(this.applicationContext.getEnvironment().getProperty(key));
    }

    public <T> Optional<T> findProperty(String key, Class<T> clazz) {
        return Optional.ofNullable(this.applicationContext.getEnvironment().getProperty(key, clazz));
    }
}

