/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import io.atleon.spring.AloStreamStatusService;
import io.atleon.spring.AtleonManagementController;
import io.atleon.spring.ConfiguredAloStream;
import io.atleon.spring.ConfiguredAloStreamStatusService;
import io.atleon.spring.Contexts;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration(proxyBeanMethods=false)
public class AtleonManagementAutoConfiguration {
    @Bean
    public AloStreamStatusService aloStreamStatusService(List<ConfiguredAloStream> listeners) {
        return new ConfiguredAloStreamStatusService(listeners);
    }

    public static class RestManagementEnabled
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return Contexts.isClassPresent(context, "org.springframework.web.bind.annotation.RestController") && Contexts.isPropertySetToTrue(context, "atleon.management.rest.enabled");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={RestManagementEnabled.class})
    public static class RestManagementConfiguration {
        @Bean
        public AtleonManagementController managementController(AloStreamStatusService service) {
            return new AtleonManagementController(service);
        }
    }
}

