/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import io.atleon.core.AloOps;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@FunctionalInterface
public interface AloFactory<T> {
    public static <T> Alo<List<T>> invertList(List<Alo<T>> list, AloFactory<List<T>> factory) {
        List values = list.stream().map(Alo::get).collect(Collectors.toList());
        Runnable acknowledger = list.stream().map(Alo::getAcknowledger).collect(Collectors.collectingAndThen(Collectors.toList(), AloOps::combineAcknowledgers));
        Consumer nacknowledger = list.stream().map(Alo::getNacknowledger).collect(Collectors.collectingAndThen(Collectors.toList(), AloOps::combineNacknowledgers));
        return factory.create(values, acknowledger, nacknowledger);
    }

    public Alo<T> create(T var1, Runnable var2, Consumer<? super Throwable> var3);
}

