/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.AloFactory;
import io.atleon.core.AloOps;
import io.atleon.core.Contextual;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Alo<T>
extends Contextual {
    public static void acknowledge(Alo<?> alo) {
        alo.getAcknowledger().run();
    }

    public static void nacknowledge(Alo<?> alo, Throwable error) {
        alo.getNacknowledger().accept(error);
    }

    default public <R> Alo<R> map(Function<? super T, ? extends R> mapper) {
        return this.propagator().create(mapper.apply(this.get()), this.getAcknowledger(), this.getNacknowledger());
    }

    default public Alo<T> reduce(BinaryOperator<T> reducer, Alo<? extends T> other) {
        Runnable acknowledger = AloOps.combineAcknowledgers(this.getAcknowledger(), other.getAcknowledger());
        Consumer<Throwable> nacknowledger = AloOps.combineNacknowledgers(this.getNacknowledger(), other.getNacknowledger());
        return this.propagator().create(reducer.apply(this.get(), other.get()), acknowledger, nacknowledger);
    }

    public <R> AloFactory<R> propagator();

    public T get();

    public Runnable getAcknowledger();

    public Consumer<? super Throwable> getNacknowledger();
}

