/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.ActivityEnforcementConfig;
import io.atleon.core.ActivityEnforcingTransformer;
import io.atleon.core.Alo;
import io.atleon.core.AloExtendedFlux;
import io.atleon.core.AloFactory;
import io.atleon.core.AloGroupedFlux;
import io.atleon.core.AloMono;
import io.atleon.core.AloOps;
import io.atleon.core.DeduplicatingTransformer;
import io.atleon.core.Deduplication;
import io.atleon.core.DeduplicationConfig;
import io.atleon.core.NumberHashGroupExtractor;
import io.atleon.core.RateLimitingConfig;
import io.atleon.core.RateLimitingTransformer;
import io.atleon.core.ResubscribingTransformer;
import io.atleon.core.ResubscriptionConfig;
import io.atleon.core.StringHashGroupExtractor;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class AloFlux<T>
implements Publisher<Alo<T>> {
    private final Flux<Alo<T>> wrapped;

    AloFlux(Flux<Alo<T>> wrapped) {
        this.wrapped = Flux.from(wrapped);
    }

    public static <T> AloFlux<T> wrap(Publisher<Alo<T>> publisher) {
        return publisher instanceof AloFlux ? (AloFlux)AloFlux.class.cast(publisher) : new AloFlux<T>(Flux.from(publisher));
    }

    public static <T> Flux<Alo<T>> toFlux(Publisher<Alo<T>> publisher) {
        return publisher instanceof AloFlux ? ((AloFlux)AloFlux.class.cast(publisher)).unwrap() : Flux.from(publisher);
    }

    public Flux<Alo<T>> unwrap() {
        return this.wrapped;
    }

    public AloFlux<T> doFirst(Runnable onFirst) {
        return new AloFlux<T>(this.wrapped.doFirst(onFirst));
    }

    public AloFlux<T> doOnCancel(Runnable onCancel) {
        return new AloFlux<T>(this.wrapped.doOnCancel(onCancel));
    }

    public AloFlux<T> doOnNext(Consumer<? super T> onNext) {
        return new AloFlux<T>(this.wrapped.doOnNext(alo -> onNext.accept((Object)alo.get())));
    }

    public AloFlux<T> doOnError(Consumer<? super Throwable> onError) {
        return new AloFlux<T>(this.wrapped.doOnError(onError));
    }

    public AloFlux<T> doFinally(Consumer<SignalType> onFinally) {
        return new AloFlux<T>(this.wrapped.doFinally(onFinally));
    }

    public AloFlux<T> filter(Predicate<? super T> predicate) {
        return new AloFlux<T>(this.wrapped.filter(AloOps.filtering(predicate, Alo::acknowledge)));
    }

    public <V> AloFlux<V> cast(Class<V> clazz) {
        return this.map(clazz::cast);
    }

    public <V> AloFlux<V> map(Function<? super T, ? extends V> mapper) {
        return new AloFlux<T>(this.wrapped.map(AloOps.mapping(mapper)));
    }

    public <V> AloFlux<V> mapNotNull(Function<? super T, ? extends V> mapper) {
        return this.mapPresent(mapper.andThen(Optional::ofNullable));
    }

    public <V> AloFlux<V> mapPresent(Function<? super T, Optional<? extends V>> mapper) {
        return new AloFlux<T>(this.wrapped.handle((alo, sink) -> {
            Alo<Object> result = alo.map(mapper);
            if (((Optional)result.get()).isPresent()) {
                sink.next(result.map(Optional::get));
            } else {
                Alo.acknowledge(alo);
            }
        }));
    }

    public <V> AloFlux<V> concatMap(Function<? super T, ? extends Publisher<V>> mapper) {
        return new AloFlux<T>(this.wrapped.concatMap(AloOps.publishing(mapper)));
    }

    public <V> AloFlux<V> concatMap(Function<? super T, ? extends Publisher<V>> mapper, int prefetch) {
        return new AloFlux<T>(this.wrapped.concatMap(AloOps.publishing(mapper), prefetch));
    }

    public <V> AloFlux<V> flatMap(Function<? super T, ? extends Publisher<V>> mapper) {
        return new AloFlux<T>(this.wrapped.flatMap(AloOps.publishing(mapper)));
    }

    public <V> AloFlux<V> flatMap(Function<? super T, ? extends Publisher<V>> mapper, int concurrency) {
        return new AloFlux<T>(this.wrapped.flatMap(AloOps.publishing(mapper), concurrency));
    }

    public <V> AloFlux<V> flatMap(Function<? super T, ? extends Publisher<V>> mapper, int concurrency, int prefetch) {
        return new AloFlux<T>(this.wrapped.flatMap(AloOps.publishing(mapper), concurrency, prefetch));
    }

    public <R, C extends Collection<R>> AloFlux<R> flatMapCollection(Function<? super T, ? extends C> mapper) {
        return new AloFlux<T>(this.wrapped.flatMapIterable(AloOps.mappingToMany(mapper, Alo::acknowledge)));
    }

    public AloFlux<List<T>> bufferTimeout(int maxSize, Duration maxTime) {
        return this.bufferTimeout(maxSize, maxTime, Schedulers.parallel(), buffer -> ((Alo)buffer.get(0)).propagator());
    }

    public AloFlux<List<T>> bufferTimeout(int maxSize, Duration maxTime, Scheduler scheduler) {
        return this.bufferTimeout(maxSize, maxTime, scheduler, buffer -> ((Alo)buffer.get(0)).propagator());
    }

    public AloFlux<List<T>> bufferTimeout(int maxSize, Duration maxTime, Function<? super List<Alo<T>>, AloFactory<List<T>>> bufferToAloFactory) {
        return this.bufferTimeout(maxSize, maxTime, Schedulers.parallel(), bufferToAloFactory);
    }

    public AloFlux<List<T>> bufferTimeout(int maxSize, Duration maxTime, Scheduler scheduler, Function<? super List<Alo<T>>, AloFactory<List<T>>> bufferToAloFactory) {
        return (AloFlux)this.wrapped.bufferTimeout(maxSize, maxTime, scheduler).map(buffer -> AloFactory.invertList(buffer, (AloFactory)bufferToAloFactory.apply((Object)buffer))).as(AloFlux::wrap);
    }

    public AloFlux<T> delayUntil(Function<? super T, ? extends Publisher<?>> triggerProvider) {
        return new AloFlux<T>(this.wrapped.delayUntil(alo -> (Publisher)triggerProvider.apply((Object)alo.get())));
    }

    public AloFlux<T> deduplicate(DeduplicationConfig config, Deduplication<T> deduplication) {
        return new AloFlux<T>(this.wrapped.transform(DeduplicatingTransformer.alo(config, deduplication)));
    }

    public AloFlux<T> deduplicate(DeduplicationConfig config, Deduplication<T> deduplication, Scheduler scheduler) {
        return new AloFlux<T>(this.wrapped.transform(DeduplicatingTransformer.alo(config, deduplication, scheduler)));
    }

    public AloMono<T> reduce(BinaryOperator<T> reducer) {
        return new AloMono(this.wrapped.reduce(AloOps.reducing(reducer)));
    }

    public AloExtendedFlux<AloGroupedFlux<Integer, T>> groupByNumberHash(Function<? super T, ? extends Number> numberExtractor, int numGroups) {
        return this.groupBy(NumberHashGroupExtractor.composed(numberExtractor, numGroups));
    }

    public <V> AloExtendedFlux<AloGroupedFlux<Integer, V>> groupByNumberHash(Function<? super T, ? extends Number> numberExtractor, int numGroups, Function<? super T, V> valueMapper) {
        return this.groupBy(NumberHashGroupExtractor.composed(numberExtractor, numGroups), valueMapper);
    }

    public AloExtendedFlux<AloGroupedFlux<Integer, T>> groupByStringHash(Function<? super T, String> stringExtractor, int numGroups) {
        return this.groupBy(StringHashGroupExtractor.composed(stringExtractor, numGroups));
    }

    public <V> AloExtendedFlux<AloGroupedFlux<Integer, V>> groupByStringHash(Function<? super T, String> stringExtractor, int numGroups, Function<? super T, V> valueMapper) {
        return this.groupBy(StringHashGroupExtractor.composed(stringExtractor, numGroups), valueMapper);
    }

    public <K> AloExtendedFlux<AloGroupedFlux<K, T>> groupBy(Function<? super T, ? extends K> groupExtractor) {
        return (AloExtendedFlux)this.wrapped.groupBy(alo -> groupExtractor.apply((Object)alo.get())).map(AloGroupedFlux::new).as(AloExtendedFlux::new);
    }

    public <K, V> AloExtendedFlux<AloGroupedFlux<K, V>> groupBy(Function<? super T, ? extends K> groupExtractor, Function<? super T, V> valueMapper) {
        return (AloExtendedFlux)this.wrapped.groupBy(alo -> groupExtractor.apply((Object)alo.get()), AloOps.mapping(valueMapper)).map(AloGroupedFlux::new).as(AloExtendedFlux::new);
    }

    public AloFlux<T> publishOn(Scheduler scheduler) {
        return new AloFlux<T>(this.wrapped.publishOn(scheduler));
    }

    public AloFlux<T> publishOn(Scheduler scheduler, int prefetch) {
        return new AloFlux<T>(this.wrapped.publishOn(scheduler, prefetch));
    }

    public AloFlux<T> subscribeOn(Scheduler scheduler) {
        return new AloFlux<T>(this.wrapped.subscribeOn(scheduler));
    }

    public AloFlux<T> metrics(String name, String ... tags) {
        if (tags.length % 2 != 0) {
            throw new IllegalArgumentException("Tags must be key-value tuples");
        }
        Flux toWrap = this.wrapped.name(name);
        for (int i = 0; i < tags.length; i += 2) {
            toWrap = toWrap.tag(tags[i], tags[i + 1]);
        }
        return new AloFlux<T>(toWrap.metrics());
    }

    public AloFlux<T> metrics(String name, Map<String, String> tags) {
        Flux toWrap = this.wrapped.name(name);
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            toWrap = toWrap.tag(entry.getKey(), entry.getValue());
        }
        return new AloFlux<T>(toWrap.metrics());
    }

    public AloFlux<T> enforceActivity(ActivityEnforcementConfig config) {
        return new AloFlux<T>(this.wrapped.transform(new ActivityEnforcingTransformer(config)));
    }

    public AloFlux<T> resubscribeOnError(String name) {
        return this.resubscribeOnError(new ResubscriptionConfig(name));
    }

    public AloFlux<T> resubscribeOnError(String name, Duration delay) {
        return this.resubscribeOnError(new ResubscriptionConfig(name, delay));
    }

    public AloFlux<T> resubscribeOnError(ResubscriptionConfig config) {
        return new AloFlux<T>(this.wrapped.transform(new ResubscribingTransformer(config)));
    }

    public AloFlux<T> limitPerSecond(double limitPerSecond) {
        return this.limitPerSecond(new RateLimitingConfig(limitPerSecond));
    }

    public AloFlux<T> limitPerSecond(RateLimitingConfig config) {
        return new AloFlux<T>(this.wrapped.transform(new RateLimitingTransformer(config)));
    }

    public <V> AloFlux<V> transform(Function<? super AloFlux<T>, ? extends Publisher<Alo<V>>> transformer) {
        return AloFlux.wrap(transformer.apply(this));
    }

    public <V> Flux<V> transformToFlux(Function<? super AloFlux<T>, ? extends Publisher<V>> transformer) {
        return Flux.from(transformer.apply(this));
    }

    public Flux<T> consumeAloAndGet(Consumer<? super Alo<? super T>> aloConsumer) {
        return this.wrapped.map(alo -> {
            aloConsumer.accept((Object)alo);
            return alo.get();
        });
    }

    public <P> P as(Function<? super AloFlux<T>, P> transformer) {
        return transformer.apply(this);
    }

    public Disposable subscribe() {
        return this.subscribe(Alo::acknowledge);
    }

    public Disposable subscribe(Consumer<? super Alo<T>> consumer) {
        return this.wrapped.subscribe(consumer);
    }

    public Disposable subscribe(Consumer<? super Alo<T>> consumer, Consumer<? super Throwable> errorConsumer) {
        return this.wrapped.subscribe(consumer, errorConsumer);
    }

    public void subscribe(Subscriber<? super Alo<T>> subscriber) {
        this.wrapped.subscribe(subscriber);
    }

    public <E extends Subscriber<? super Alo<T>>> E subscribeWith(E subscriber) {
        return (E)this.wrapped.subscribeWith(subscriber);
    }
}

