/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.util.Configurable;
import java.util.List;
import java.util.Map;

public interface AloQueueListener
extends Configurable {
    public static AloQueueListener noOp() {
        return new NoOp();
    }

    public static AloQueueListener combine(List<AloQueueListener> listeners) {
        return listeners.size() == 1 ? listeners.get(0) : new Composite(listeners);
    }

    default public void configure(Map<String, ?> properties) {
    }

    default public void created(Object group) {
    }

    default public void enqueued(Object group, long count) {
    }

    default public void dequeued(Object group, long count) {
    }

    default public void close() {
    }

    public static class NoOp
    implements AloQueueListener {
        private NoOp() {
        }
    }

    public static class Composite
    implements AloQueueListener {
        private final List<AloQueueListener> listeners;

        private Composite(List<AloQueueListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void configure(Map<String, ?> properties) {
            this.listeners.forEach(listener -> listener.configure(properties));
        }

        @Override
        public void created(Object group) {
            this.listeners.forEach(listener -> listener.created(group));
        }

        @Override
        public void enqueued(Object group, long count) {
            this.listeners.forEach(listener -> listener.enqueued(group, count));
        }

        @Override
        public void dequeued(Object group, long count) {
            this.listeners.forEach(listener -> listener.dequeued(group, count));
        }

        @Override
        public void close() {
            this.listeners.forEach(AloQueueListener::close);
        }
    }
}

