/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.ConfigProcessor;
import io.atleon.util.ConfigLoading;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import reactor.core.publisher.Mono;

public class PropertiesFileConfigProcessor
implements ConfigProcessor {
    public static final String FILES_PROPERTY = "atleon.config.properties.files";

    @Override
    public Mono<Map<String, Object>> process(Map<String, Object> configs) {
        if (configs.containsKey(FILES_PROPERTY)) {
            HashMap<String, Object> result = new HashMap<String, Object>(configs);
            result.remove(FILES_PROPERTY);
            ConfigLoading.loadSetOfStringOrEmpty(configs, (String)FILES_PROPERTY).forEach(fileSpec -> this.processFile((String)fileSpec, result::put));
            return Mono.just(result);
        }
        return Mono.just(configs);
    }

    private void processFile(String fileSpec, BiConsumer<String, Object> propertyConsumer) {
        String[] splitSpec = fileSpec.split(":");
        String fileName = splitSpec[0];
        String prefix = splitSpec.length > 1 ? splitSpec[1] + "." : "";
        this.loadProperties(fileName).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String keyAsString = key.toString();
            if (keyAsString.startsWith(prefix)) {
                propertyConsumer.accept(keyAsString.substring(prefix.length()), value);
            }
        }));
    }

    private Properties loadProperties(String fileName) {
        Properties properties;
        FileInputStream inputStream = new FileInputStream(fileName);
        try {
            Properties properties2 = new Properties();
            properties2.load(inputStream);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load properties file: " + fileName, e);
            }
        }
        ((InputStream)inputStream).close();
        return properties;
    }
}

