/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import io.atleon.util.Configurable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@FunctionalInterface
public interface AloDecorator<T>
extends Configurable {
    public static final int INNERMOST_ORDER = Integer.MIN_VALUE;
    public static final int OUTERMOST_ORDER = Integer.MAX_VALUE;

    public static <T> AloDecorator<T> combine(List<AloDecorator<T>> decorators) {
        return decorators.size() == 1 ? decorators.get(0) : new Composite(decorators);
    }

    default public void configure(Map<String, ?> properties) {
    }

    default public int order() {
        return 0;
    }

    public Alo<T> decorate(Alo<T> var1);

    public static class Composite<T>
    implements AloDecorator<T> {
        private final List<AloDecorator<T>> decorators;

        private Composite(List<AloDecorator<T>> decorators) {
            this.decorators = decorators.stream().sorted(Comparator.comparing(AloDecorator::order)).collect(Collectors.toList());
        }

        @Override
        public void configure(Map<String, ?> properties) {
            this.decorators.forEach(decorator -> decorator.configure(properties));
        }

        @Override
        public int order() {
            return this.decorators.isEmpty() ? Integer.MAX_VALUE : this.decorators.get(this.decorators.size() - 1).order();
        }

        @Override
        public Alo<T> decorate(Alo<T> alo) {
            for (AloDecorator<T> decorator : this.decorators) {
                alo = decorator.decorate(alo);
            }
            return alo;
        }
    }
}

