/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.AloStream;
import io.atleon.core.AloStreamConfig;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;

public abstract class SelfConfigurableAloStream
extends AloStream<SelfConfigurableAloStream>
implements AloStreamConfig {
    private final AtomicReference<Integer> instanceId = new AtomicReference();

    @Override
    public String name() {
        return this.instanceId().map(id -> AloStreamConfig.super.name() + "-i" + id).orElseGet(() -> AloStreamConfig.super.name());
    }

    @Override
    @NotNull
    protected final Disposable startDisposable(@NotNull SelfConfigurableAloStream self) {
        return this.startDisposable();
    }

    @NotNull
    protected abstract Disposable startDisposable();

    protected Scheduler newBoundedElasticScheduler(int threadCap) {
        return SelfConfigurableAloStream.newBoundedElasticScheduler(this.name(), threadCap);
    }

    protected final Optional<Integer> instanceId() {
        return Optional.ofNullable(this.instanceId.get());
    }

    SelfConfigurableAloStream withInstanceId(int instanceId) {
        this.instanceId.set(instanceId);
        return this;
    }
}

