/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.context;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;

public abstract class AloContext {
    private static final AloContext NO_OP = new NoOp();
    private static final ThreadLocal<AloContext> ACTIVE_CONTEXT = new ThreadLocal();

    private AloContext() {
    }

    public static AloContext active() {
        AloContext context = ACTIVE_CONTEXT.get();
        return context == null ? NO_OP : context;
    }

    public static AloContext create() {
        return new Impl();
    }

    public abstract <T> Optional<T> get(Key<T> var1);

    public abstract <T> boolean set(Key<T> var1, T var2);

    final void run(Runnable runnable) {
        AloContext previousContext = ACTIVE_CONTEXT.get();
        try {
            ACTIVE_CONTEXT.set(this);
            runnable.run();
        }
        finally {
            ACTIVE_CONTEXT.set(previousContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T supply(Supplier<T> supplier) {
        AloContext previousContext = ACTIVE_CONTEXT.get();
        try {
            ACTIVE_CONTEXT.set(this);
            T t = supplier.get();
            return t;
        }
        finally {
            ACTIVE_CONTEXT.set(previousContext);
        }
    }

    abstract AloContext copy();

    abstract void merge(AloContext var1);

    abstract void forEach(BiConsumer<Key<?>, Object> var1);

    private static final class Impl
    extends AloContext {
        private final Map<Key<?>, Object> map = new ConcurrentHashMap();

        private Impl() {
        }

        @Override
        public <T> Optional<T> get(Key<T> key) {
            return Optional.ofNullable(this.map.get(key));
        }

        @Override
        public <T> boolean set(Key<T> key, T value) {
            return this.map.putIfAbsent(key, value) == null;
        }

        @Override
        AloContext copy() {
            Impl copy = new Impl();
            copy.map.putAll(this.map);
            return copy;
        }

        @Override
        void merge(AloContext other) {
            other.forEach((key, value) -> this.map.compute((Key<?>)key, (__, previous) -> Impl.remap(key, previous, value)));
        }

        @Override
        void forEach(BiConsumer<Key<?>, Object> consumer) {
            this.map.forEach(consumer);
        }

        private static <T> T remap(Key<T> key, T previous, T next) {
            return previous == null ? next : key.reduce(previous, next);
        }
    }

    private static final class NoOp
    extends AloContext {
        private NoOp() {
        }

        @Override
        public <T> Optional<T> get(Key<T> key) {
            return Optional.empty();
        }

        @Override
        public <T> boolean set(Key<T> key, T value) {
            return false;
        }

        @Override
        AloContext copy() {
            return this;
        }

        @Override
        void merge(AloContext other) {
        }

        @Override
        void forEach(BiConsumer<Key<?>, Object> consumer) {
        }
    }

    public static final class Key<T> {
        private final String name;
        private final BinaryOperator<T> reducer;

        private Key(String name, BinaryOperator<T> reducer) {
            this.name = name;
            this.reducer = reducer;
        }

        public static <T> Key<T> single(String name) {
            return new Key<T>(name, (previous, next) -> previous);
        }

        public static <T extends Comparable<? super T>> Key<T> min(String name) {
            return Key.min(name, Comparator.naturalOrder());
        }

        public static <T> Key<T> min(String name, Comparator<T> comparator) {
            return new Key<T>(name, (v1, v2) -> comparator.compare(v1, v2) <= 0 ? v1 : v2);
        }

        public String toString() {
            return this.name;
        }

        T reduce(T previous, T next) {
            return (T)this.reducer.apply(previous, next);
        }
    }
}

