/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import java.time.Duration;

public final class DeduplicationConfig {
    private final Duration deduplicationTimeout;
    private final long maxDeduplicationSize;
    private final int deduplicationConcurrency;
    private final int deduplicationSourcePrefetch;

    public DeduplicationConfig(Duration deduplicationTimeout) {
        this(deduplicationTimeout, Long.MAX_VALUE);
    }

    public DeduplicationConfig(Duration deduplicationTimeout, long maxDeduplicationSize) {
        this(deduplicationTimeout, maxDeduplicationSize, Integer.MAX_VALUE);
    }

    public DeduplicationConfig(Duration deduplicationTimeout, long maxDeduplicationSize, int deduplicationConcurrency) {
        this(deduplicationTimeout, maxDeduplicationSize, deduplicationConcurrency, 256);
    }

    public DeduplicationConfig(Duration deduplicationTimeout, long maxDeduplicationSize, int deduplicationConcurrency, int deduplicationSourcePrefetch) {
        this.deduplicationTimeout = deduplicationTimeout;
        this.maxDeduplicationSize = maxDeduplicationSize;
        this.deduplicationConcurrency = deduplicationConcurrency;
        this.deduplicationSourcePrefetch = deduplicationSourcePrefetch;
    }

    public boolean isEnabled() {
        return !this.deduplicationTimeout.isNegative() && !this.deduplicationTimeout.isZero();
    }

    @Deprecated
    public Duration getDeduplicationDuration() {
        return this.getDeduplicationTimeout();
    }

    public Duration getDeduplicationTimeout() {
        return this.deduplicationTimeout;
    }

    public long getMaxDeduplicationSize() {
        return this.maxDeduplicationSize;
    }

    public int getDeduplicationConcurrency() {
        return this.deduplicationConcurrency;
    }

    public int getDeduplicationSourcePrefetch() {
        return this.deduplicationSourcePrefetch;
    }
}

