/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.SenderResult;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ErrorDelegator<T>
extends BiFunction<T, Throwable, Publisher<?>> {
    public static <T> Sending<T, T> sending(Function<? super T, Mono<? extends SenderResult>> sender) {
        return new Sending(__ -> true, (data, __) -> data, UnaryOperator.identity(), sender);
    }

    @Override
    public Publisher<?> apply(T var1, Throwable var2);

    public static final class Sending<T, S>
    implements ErrorDelegator<T> {
        private final Predicate<Throwable> predicate;
        private final BiFunction<T, Throwable, S> mapper;
        private final UnaryOperator<Mono<S>> beforeSend;
        private final Function<? super S, Mono<? extends SenderResult>> sender;

        private Sending(Predicate<Throwable> predicate, BiFunction<T, Throwable, S> mapper, UnaryOperator<Mono<S>> beforeSend, Function<? super S, Mono<? extends SenderResult>> sender) {
            this.predicate = predicate;
            this.mapper = mapper;
            this.beforeSend = beforeSend;
            this.sender = sender;
        }

        public Sending<T, S> errorMustMatch(Predicate<Throwable> predicate) {
            return new Sending<T, S>(predicate, this.mapper, this.beforeSend, this.sender);
        }

        public <U> Sending<U, S> composeData(Function<U, S> mapper) {
            return this.composeData((U data, Throwable __) -> mapper.apply(data));
        }

        public <U> Sending<U, S> composeData(BiFunction<U, Throwable, S> mapper) {
            return new Sending<U, S>(this.predicate, mapper, this.beforeSend, this.sender);
        }

        public Sending<T, S> beforeSend(UnaryOperator<Mono<S>> beforeSend) {
            return new Sending<T, S>(this.predicate, this.mapper, beforeSend, this.sender);
        }

        @Override
        public Mono<SenderResult> apply(T data, Throwable error) {
            if (this.predicate.test(error)) {
                return Mono.just(this.mapper.apply(data, error)).transform(this.beforeSend).flatMap(this.sender).flatMap(result -> result.failureCause().map(Mono::error).orElse(Mono.just((Object)result)));
            }
            return Mono.error((Throwable)error);
        }
    }
}

