/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import io.atleon.core.AloFlux;
import io.atleon.core.AloGroupedFlux;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;

public class GroupFlux<K, T> {
    private final Flux<AloGroupedFlux<K, T>> wrapped;
    private final int cardinality;

    GroupFlux(Flux<AloGroupedFlux<K, T>> wrapped, int cardinality) {
        this.wrapped = wrapped;
        this.cardinality = cardinality;
    }

    static <K, T> GroupFlux<K, T> create(Flux<AloGroupedFlux<K, T>> flux, int cardinality) {
        return new GroupFlux<K, T>(flux, cardinality);
    }

    public Flux<AloGroupedFlux<K, T>> unwrap() {
        return this.wrapped;
    }

    public GroupFlux<K, T> innerFilter(Predicate<? super T> predicate) {
        return this.map(group -> group.filter(predicate));
    }

    public <V> GroupFlux<K, V> innerMap(Function<? super T, ? extends V> mapper) {
        return this.map(group -> group.map(mapper));
    }

    public <V> GroupFlux<K, V> innerMapNotNull(Function<? super T, ? extends V> mapper) {
        return this.map(group -> group.mapNotNull(mapper));
    }

    public <V> GroupFlux<K, V> innerMapPresent(Function<? super T, Optional<? extends V>> mapper) {
        return this.map(group -> group.mapPresent(mapper));
    }

    public GroupFlux<K, Void> innerConsume(Consumer<? super T> consumer) {
        return this.map(group -> group.consume(consumer));
    }

    public <V> GroupFlux<K, V> innerConcatMap(Function<? super T, ? extends Publisher<V>> mapper) {
        return this.map(group -> group.concatMap(mapper));
    }

    public <V> GroupFlux<K, V> innerConcatMap(Function<? super T, ? extends Publisher<V>> mapper, int prefetch) {
        return this.map(group -> group.concatMap(mapper, prefetch));
    }

    public <V> GroupFlux<K, V> innerFlatMapIterable(Function<? super T, ? extends Iterable<? extends V>> mapper) {
        return this.map(group -> group.flatMapIterable(mapper));
    }

    public GroupFlux<K, List<T>> innerBufferTimeout(int maxSize, Duration maxTime) {
        return this.map(group -> group.bufferTimeout(maxSize, maxTime));
    }

    public GroupFlux<K, List<T>> innerBufferTimeout(int maxSize, Duration maxTime, Scheduler scheduler) {
        return this.map(group -> group.bufferTimeout(maxSize, maxTime, scheduler));
    }

    public GroupFlux<K, T> innerPublishOn(Scheduler scheduler) {
        return this.map(group -> group.publishOn(scheduler));
    }

    public GroupFlux<K, T> innerPublishOn(Scheduler scheduler, int prefetch) {
        return this.map(group -> group.publishOn(scheduler, prefetch));
    }

    @Deprecated
    public <V> GroupFlux<K, V> mapExtended(Function<? super AloGroupedFlux<K, T>, ? extends Publisher<Alo<V>>> mapper) {
        return this.map(mapper);
    }

    public <V> GroupFlux<K, V> map(Function<? super AloGroupedFlux<K, T>, ? extends Publisher<Alo<V>>> mapper) {
        return new GroupFlux<K, T>(this.wrapped.map(group -> group.transformGrouped(mapper)), this.cardinality);
    }

    public AloFlux<T> flatMapAlo() {
        return this.flatMapAlo(Function.identity());
    }

    public <V> AloFlux<V> flatMapAlo(Function<? super AloGroupedFlux<K, T>, ? extends Publisher<Alo<V>>> mapper) {
        return (AloFlux)this.wrapped.flatMap(mapper, this.cardinality).as(AloFlux::wrap);
    }
}

