/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class AloErrorDelegatingMapper<T>
implements Function<Alo<T>, Alo<T>> {
    private final BiFunction<? super T, ? super Throwable, ? extends Publisher<?>> delegate;

    AloErrorDelegatingMapper(BiFunction<? super T, ? super Throwable, ? extends Publisher<?>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Alo<T> apply(Alo<T> alo) {
        Consumer<Throwable> nacknowledger = this.buildNacknowledger(alo.get(), alo.getAcknowledger(), alo.getNacknowledger());
        return alo.propagator().create(alo.get(), alo.getAcknowledger(), nacknowledger);
    }

    private Consumer<Throwable> buildNacknowledger(T t, Runnable acknowledger, Consumer<? super Throwable> nacknowledger) {
        return error -> this.delegateError(t, (Throwable)error).subscribe(__ -> {}, nacknowledger, acknowledger);
    }

    private Mono<Void> delegateError(T t, Throwable error) {
        try {
            return Mono.when((Publisher[])new Publisher[]{this.delegate.apply(t, error)}).onErrorMap(delegateError -> AloErrorDelegatingMapper.consolidateErrors(error, delegateError));
        }
        catch (Throwable delegateError2) {
            return Mono.error((Throwable)AloErrorDelegatingMapper.consolidateErrors(error, delegateError2));
        }
    }

    private static Throwable consolidateErrors(Throwable originalError, Throwable delegateError) {
        if (originalError != delegateError) {
            originalError.addSuppressed(delegateError);
        }
        return originalError;
    }
}

