/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import java.util.function.Consumer;
import java.util.function.Function;

public interface AloComponentExtractor<T, V> {
    public static <T, V> AloComponentExtractor<T, V> composed(Function<T, Runnable> acknowledgerExtractor, Function<T, Consumer<? super Throwable>> nacknowledgerExtractor, Function<? super T, ? extends V> valueExtractor) {
        return new Composed(acknowledgerExtractor, nacknowledgerExtractor, valueExtractor);
    }

    public Runnable nativeAcknowledger(T var1);

    public Consumer<? super Throwable> nativeNacknowledger(T var1);

    public V value(T var1);

    public static class Composed<T, V>
    implements AloComponentExtractor<T, V> {
        private final Function<T, Runnable> acknowledgerExtractor;
        private final Function<T, Consumer<? super Throwable>> nacknowledgerExtractor;
        private final Function<? super T, ? extends V> valueExtractor;

        private Composed(Function<T, Runnable> acknowledgerExtractor, Function<T, Consumer<? super Throwable>> nacknowledgerExtractor, Function<? super T, ? extends V> valueExtractor) {
            this.acknowledgerExtractor = acknowledgerExtractor;
            this.nacknowledgerExtractor = nacknowledgerExtractor;
            this.valueExtractor = valueExtractor;
        }

        @Override
        public Runnable nativeAcknowledger(T t) {
            return this.acknowledgerExtractor.apply(t);
        }

        @Override
        public Consumer<? super Throwable> nativeNacknowledger(T t) {
            return this.nacknowledgerExtractor.apply(t);
        }

        @Override
        public V value(T t) {
            return this.valueExtractor.apply(t);
        }
    }
}

