/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.AcknowledgingCollection;
import io.atleon.core.AcknowledgingPublisher;
import io.atleon.core.ActivityEnforcementConfig;
import io.atleon.core.ActivityEnforcingTransformer;
import io.atleon.core.Alo;
import io.atleon.core.AloFailureStrategy;
import io.atleon.core.AloGroupedFlux;
import io.atleon.core.AloOps;
import io.atleon.core.DeduplicatingTransformer;
import io.atleon.core.Deduplication;
import io.atleon.core.DeduplicationConfig;
import io.atleon.core.GroupFlux;
import io.atleon.core.NumberHashGroupExtractor;
import io.atleon.core.RateLimitingConfig;
import io.atleon.core.RateLimitingTransformer;
import io.atleon.core.ResubscribingTransformer;
import io.atleon.core.ResubscriptionConfig;
import io.atleon.core.StringHashGroupExtractor;
import io.atleon.core.WarningAloSubscriber;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Disposable;
import reactor.core.observability.SignalListenerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class AloFlux<T>
implements Publisher<Alo<T>> {
    private final Flux<Alo<T>> wrapped;

    AloFlux(Flux<Alo<T>> wrapped) {
        this.wrapped = Flux.from(wrapped);
    }

    public static <T> AloFlux<T> wrap(Publisher<? extends Alo<T>> publisher) {
        return publisher instanceof AloFlux ? (AloFlux)AloFlux.class.cast(publisher) : new AloFlux<T>(Flux.from(publisher));
    }

    public static <T> Flux<Alo<T>> toFlux(Publisher<? extends Alo<T>> publisher) {
        return publisher instanceof AloFlux ? ((AloFlux)AloFlux.class.cast(publisher)).unwrap() : Flux.from(publisher);
    }

    public Flux<Alo<T>> unwrap() {
        return this.wrapped;
    }

    public AloFlux<T> doFirst(Runnable onFirst) {
        return new AloFlux<T>(this.wrapped.doFirst(onFirst));
    }

    public AloFlux<T> doOnCancel(Runnable onCancel) {
        return new AloFlux<T>(this.wrapped.doOnCancel(onCancel));
    }

    public AloFlux<T> doOnNext(Consumer<? super T> onNext) {
        return new AloFlux<T>(this.wrapped.doOnNext(alo -> onNext.accept((Object)alo.get())));
    }

    public AloFlux<T> doOnError(Consumer<? super Throwable> onError) {
        return new AloFlux<T>(this.wrapped.doOnError(onError));
    }

    public AloFlux<T> doFinally(Consumer<SignalType> onFinally) {
        return new AloFlux<T>(this.wrapped.doFinally(onFinally));
    }

    public AloFlux<T> filter(Predicate<? super T> predicate) {
        return new AloFlux<T>(this.wrapped.handle(AloOps.filteringHandler(predicate, Alo::acknowledge)));
    }

    public <V> AloFlux<V> cast(Class<V> clazz) {
        return this.map(clazz::cast);
    }

    public <V> AloFlux<V> map(Function<? super T, ? extends V> mapper) {
        return new AloFlux<T>(this.wrapped.handle(AloOps.mappingHandler(mapper)));
    }

    public <V> AloFlux<V> mapNotNull(Function<? super T, ? extends V> mapper) {
        return this.mapPresent(mapper.andThen(Optional::ofNullable));
    }

    public <V> AloFlux<V> mapPresent(Function<? super T, Optional<? extends V>> mapper) {
        return new AloFlux<T>(this.wrapped.handle(AloOps.mappingPresentHandler(mapper, Alo::acknowledge)));
    }

    public AloFlux<Void> consume(Consumer<? super T> consumer) {
        return new AloFlux<Void>(this.wrapped.handle(AloOps.consumingHandler(consumer, Alo::acknowledge)));
    }

    public <V> AloFlux<V> concatMap(Function<? super T, ? extends Publisher<V>> mapper) {
        return (AloFlux)this.wrapped.handle(AloOps.mappingHandler(mapper)).concatMap(AcknowledgingPublisher::fromAloPublisher).as(AloFlux::new);
    }

    public <V> AloFlux<V> concatMap(Function<? super T, ? extends Publisher<V>> mapper, int prefetch) {
        return (AloFlux)this.wrapped.handle(AloOps.mappingHandler(mapper)).concatMap(AcknowledgingPublisher::fromAloPublisher, prefetch).as(AloFlux::new);
    }

    public <V> AloFlux<V> flatMap(Function<? super T, ? extends Publisher<V>> mapper) {
        return (AloFlux)this.wrapped.handle(AloOps.mappingHandler(mapper)).flatMap(AcknowledgingPublisher::fromAloPublisher).as(AloFlux::new);
    }

    public <V> AloFlux<V> flatMap(Function<? super T, ? extends Publisher<V>> mapper, int concurrency) {
        return (AloFlux)this.wrapped.handle(AloOps.mappingHandler(mapper)).flatMap(AcknowledgingPublisher::fromAloPublisher, concurrency).as(AloFlux::new);
    }

    public <V> AloFlux<V> flatMap(Function<? super T, ? extends Publisher<V>> mapper, int concurrency, int prefetch) {
        return (AloFlux)this.wrapped.handle(AloOps.mappingHandler(mapper)).flatMap(AcknowledgingPublisher::fromAloPublisher, concurrency, prefetch).as(AloFlux::new);
    }

    public <R, C extends Collection<R>> AloFlux<R> flatMapCollection(Function<? super T, ? extends C> mapper) {
        return (AloFlux)this.wrapped.handle(AloOps.mappingToManyHandler(mapper, Alo::acknowledge)).flatMapIterable(AcknowledgingCollection::fromNonEmptyAloCollection).as(AloFlux::new);
    }

    public AloFlux<List<T>> bufferTimeout(int maxSize, Duration maxTime) {
        return this.bufferTimeout(maxSize, maxTime, Schedulers.parallel());
    }

    public AloFlux<List<T>> bufferTimeout(int maxSize, Duration maxTime, Scheduler scheduler) {
        return (AloFlux)this.wrapped.bufferTimeout(maxSize, maxTime, scheduler).map(AloOps::fanIn).as(AloFlux::wrap);
    }

    public AloFlux<T> delayUntil(Function<? super T, ? extends Publisher<?>> triggerProvider) {
        return new AloFlux<T>(this.wrapped.delayUntil(alo -> (Publisher)triggerProvider.apply((Object)alo.get())));
    }

    public AloFlux<T> deduplicate(DeduplicationConfig config, Deduplication<T> deduplication) {
        return this.deduplicate(config, deduplication, Schedulers.boundedElastic());
    }

    public AloFlux<T> deduplicate(DeduplicationConfig config, Deduplication<T> deduplication, Scheduler scheduler) {
        return new AloFlux<T>(this.wrapped.transform(DeduplicatingTransformer.alo(config, deduplication, scheduler)));
    }

    public GroupFlux<AloGroupedFlux<Integer, T>> groupByNumberHash(Function<? super T, ? extends Number> numberExtractor, int numGroups) {
        return this.groupBy(NumberHashGroupExtractor.composed(numberExtractor, numGroups), numGroups);
    }

    public <V> GroupFlux<AloGroupedFlux<Integer, V>> groupByNumberHash(Function<? super T, ? extends Number> numberExtractor, int numGroups, Function<? super T, V> valueMapper) {
        return this.groupBy(NumberHashGroupExtractor.composed(numberExtractor, numGroups), numGroups, valueMapper);
    }

    public GroupFlux<AloGroupedFlux<Integer, T>> groupByStringHash(Function<? super T, String> stringExtractor, int numGroups) {
        return this.groupBy(StringHashGroupExtractor.composed(stringExtractor, numGroups), numGroups);
    }

    public <V> GroupFlux<AloGroupedFlux<Integer, V>> groupByStringHash(Function<? super T, String> stringExtractor, int numGroups, Function<? super T, V> valueMapper) {
        return this.groupBy(StringHashGroupExtractor.composed(stringExtractor, numGroups), numGroups, valueMapper);
    }

    public <K> GroupFlux<AloGroupedFlux<K, T>> groupBy(Function<? super T, ? extends K> groupExtractor, int cardinality) {
        return (GroupFlux)this.wrapped.groupBy(alo -> groupExtractor.apply((Object)alo.get())).map(AloGroupedFlux::create).as(flux -> new GroupFlux(flux, cardinality));
    }

    public <K, V> GroupFlux<AloGroupedFlux<K, V>> groupBy(Function<? super T, ? extends K> groupExtractor, int cardinality, Function<? super T, V> valueMapper) {
        BiConsumer aloValueMappingHandler = AloOps.mappingHandler(valueMapper);
        return (GroupFlux)this.wrapped.groupBy(alo -> groupExtractor.apply((Object)alo.get())).map(groupedFlux -> AloGroupedFlux.create(groupedFlux, aloValueMappingHandler)).as(flux -> new GroupFlux(flux, cardinality));
    }

    public AloFlux<T> publishOn(Scheduler scheduler) {
        return new AloFlux<T>(this.wrapped.publishOn(scheduler));
    }

    public AloFlux<T> publishOn(Scheduler scheduler, int prefetch) {
        return new AloFlux<T>(this.wrapped.publishOn(scheduler, prefetch));
    }

    public AloFlux<T> subscribeOn(Scheduler scheduler) {
        return new AloFlux<T>(this.wrapped.subscribeOn(scheduler));
    }

    @Deprecated
    public AloFlux<T> metrics(String name, String ... tags) {
        if (tags.length % 2 != 0) {
            throw new IllegalArgumentException("Tags must be key-value tuples");
        }
        Flux toWrap = this.wrapped.name(name);
        for (int i = 0; i < tags.length; i += 2) {
            toWrap = toWrap.tag(tags[i], tags[i + 1]);
        }
        return new AloFlux<T>(toWrap.metrics());
    }

    @Deprecated
    public AloFlux<T> metrics(String name, Map<String, String> tags) {
        Flux toWrap = this.wrapped.name(name);
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            toWrap = toWrap.tag(entry.getKey(), entry.getValue());
        }
        return new AloFlux<T>(toWrap.metrics());
    }

    public AloFlux<T> tap(SignalListenerFactory<Alo<T>, ?> signalListenerFactory) {
        return new AloFlux<T>(this.wrapped.tap(signalListenerFactory));
    }

    public AloFlux<T> enforceActivity(ActivityEnforcementConfig config) {
        return new AloFlux<T>(this.wrapped.transform(new ActivityEnforcingTransformer(config)));
    }

    public AloFlux<T> resubscribeOnError(String name) {
        return this.resubscribeOnError(new ResubscriptionConfig(name));
    }

    public AloFlux<T> resubscribeOnError(String name, Duration delay) {
        return this.resubscribeOnError(new ResubscriptionConfig(name, delay));
    }

    public AloFlux<T> resubscribeOnError(ResubscriptionConfig config) {
        return new AloFlux<T>(this.wrapped.transform(new ResubscribingTransformer(config)));
    }

    public AloFlux<T> limitPerSecond(double limitPerSecond) {
        return this.limitPerSecond(new RateLimitingConfig(limitPerSecond));
    }

    public AloFlux<T> limitPerSecond(RateLimitingConfig config) {
        return new AloFlux<T>(this.wrapped.transform(new RateLimitingTransformer(config, Schedulers.boundedElastic())));
    }

    public AloFlux<T> processFailure(Predicate<? super T> isFailure, Function<? super T, ? extends Throwable> errorExtractor) {
        return new AloFlux<T>(this.wrapped.handle(AloOps.failureProcessingHandler(isFailure, errorExtractor)));
    }

    public AloFlux<T> onAloErrorEmit() {
        return new AloFlux<T>(this.wrapped.contextWrite((ContextView)Context.of(AloFailureStrategy.class, (Object)AloFailureStrategy.emit())));
    }

    public AloFlux<T> onAloErrorEmitUnless(Predicate<? super Throwable> errorPredicate) {
        return this.onAloErrorEmitUnless((Object __, ? super Throwable error) -> errorPredicate.test((Throwable)error));
    }

    public AloFlux<T> onAloErrorEmitUnless(BiPredicate<Object, ? super Throwable> errorPredicate) {
        AloFailureStrategy aloFailureStrategy = AloFailureStrategy.emit(errorPredicate.negate());
        return new AloFlux<T>(this.wrapped.contextWrite((ContextView)Context.of(AloFailureStrategy.class, (Object)aloFailureStrategy)));
    }

    public AloFlux<T> onAloErrorDelegate() {
        return new AloFlux<T>(this.wrapped.contextWrite((ContextView)Context.of(AloFailureStrategy.class, (Object)AloFailureStrategy.delegate())));
    }

    public AloFlux<T> onAloErrorDelegateUnless(Predicate<? super Throwable> errorPredicate) {
        return this.onAloErrorDelegateUnless((Object __, ? super Throwable error) -> errorPredicate.test((Throwable)error));
    }

    public AloFlux<T> onAloErrorDelegateUnless(BiPredicate<Object, ? super Throwable> errorPredicate) {
        AloFailureStrategy aloFailureStrategy = AloFailureStrategy.delegate(errorPredicate.negate());
        return new AloFlux<T>(this.wrapped.contextWrite((ContextView)Context.of(AloFailureStrategy.class, (Object)aloFailureStrategy)));
    }

    public <V> AloFlux<V> transform(Function<? super AloFlux<T>, ? extends Publisher<Alo<V>>> transformer) {
        return AloFlux.wrap(transformer.apply(this));
    }

    public <V> Flux<V> transformToFlux(Function<? super AloFlux<T>, ? extends Publisher<V>> transformer) {
        return Flux.from(transformer.apply(this));
    }

    public Flux<T> consumeAloAndGet(Consumer<? super Alo<? super T>> aloConsumer) {
        return this.wrapped.map(alo -> {
            aloConsumer.accept((Object)alo);
            return alo.get();
        });
    }

    public <P> P as(Function<? super AloFlux<T>, P> transformer) {
        return transformer.apply(this);
    }

    public Disposable subscribe() {
        return (Disposable)this.subscribeWith((Subscriber)new WarningAloSubscriber());
    }

    public Disposable subscribe(Consumer<? super Alo<T>> consumer) {
        return this.wrapped.subscribe(consumer);
    }

    public Disposable subscribe(Consumer<? super Alo<T>> consumer, Consumer<? super Throwable> errorConsumer) {
        return this.wrapped.subscribe(consumer, errorConsumer);
    }

    public void subscribe(Subscriber<? super Alo<T>> subscriber) {
        this.wrapped.subscribe(subscriber);
    }

    public <E extends Subscriber<? super Alo<T>>> E subscribeWith(E subscriber) {
        return (E)this.wrapped.subscribeWith(subscriber);
    }
}

