/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import java.time.Duration;

public final class ActivityEnforcementConfig {
    public static final Duration DEFAULT_DELAY = Duration.ofMinutes(1L);
    public static final Duration DEFAULT_INTERVAL = Duration.ofMinutes(1L);
    private final String name;
    private final Duration maxInactivity;
    private final Duration delay;
    private final Duration interval;

    public ActivityEnforcementConfig(String name, Duration maxInactivity) {
        this(name, maxInactivity, DEFAULT_DELAY, DEFAULT_INTERVAL);
    }

    public ActivityEnforcementConfig(String name, Duration maxInactivity, Duration delay) {
        this(name, maxInactivity, delay, DEFAULT_INTERVAL);
    }

    public ActivityEnforcementConfig(String name, Duration maxInactivity, Duration delay, Duration interval) {
        this.name = name;
        this.maxInactivity = maxInactivity;
        this.delay = delay;
        this.interval = interval;
    }

    public boolean isEnabled() {
        return !this.maxInactivity.isZero() && !this.maxInactivity.isNegative();
    }

    public String getName() {
        return this.name;
    }

    public Duration getMaxInactivity() {
        return this.maxInactivity;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public Duration getInterval() {
        return this.interval;
    }
}

