/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.core;

import io.atleon.core.Alo;
import io.atleon.core.AloFactory;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class AcknowledgingCollection<T>
extends AbstractCollection<Alo<T>> {
    private final Collection<T> collection;
    private final Collection<T> unacknowledged;
    private final Runnable acknowledger;
    private final Consumer<? super Throwable> nacknowledger;
    private final AloFactory<T> factory;

    public AcknowledgingCollection(Collection<T> collection, Runnable acknowledger, Consumer<? super Throwable> nacknowledger, AloFactory<T> factory) {
        this.collection = collection;
        this.unacknowledged = collection.stream().collect(Collectors.toCollection(() -> Collections.newSetFromMap(new IdentityHashMap(collection.size()))));
        this.acknowledger = acknowledger;
        this.nacknowledger = nacknowledger;
        this.factory = factory;
    }

    @Override
    public String toString() {
        return "AcknowledgingCollection(" + this.collection + ")";
    }

    @Override
    public Iterator<Alo<T>> iterator() {
        final Iterator<T> iterator = this.collection.iterator();
        return new Iterator<Alo<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Alo<T> next() {
                return AcknowledgingCollection.this.wrap(iterator.next());
            }
        };
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    private Alo<T> wrap(T value) {
        return this.factory.create(value, () -> {
            Collection<T> collection = this.unacknowledged;
            synchronized (collection) {
                if (this.unacknowledged.remove(value) && this.unacknowledged.isEmpty()) {
                    this.acknowledger.run();
                }
            }
        }, error -> {
            Collection<T> collection = this.unacknowledged;
            synchronized (collection) {
                if (this.unacknowledged.contains(value)) {
                    this.unacknowledged.clear();
                    this.nacknowledger.accept((Throwable)error);
                }
            }
        });
    }
}

