/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import io.atleon.core.SenderResult;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class SqsSenderResult<C>
implements SenderResult {
    private final String requestId;
    private final SuccessMetadata successMetadata;
    private final Throwable error;
    private final C correlationMetadata;

    private SqsSenderResult(String requestId, SuccessMetadata successMetadata, Throwable error, C correlationMetadata) {
        this.requestId = requestId;
        this.successMetadata = successMetadata;
        this.error = error;
        this.correlationMetadata = correlationMetadata;
    }

    public static <C> SqsSenderResult<C> success(String requestId, String messageId, String sequenceNumber, C correlationMetadata) {
        SuccessMetadata successMetadata = new SuccessMetadata(messageId, sequenceNumber);
        return new SqsSenderResult<C>(requestId, successMetadata, null, correlationMetadata);
    }

    public static <C> SqsSenderResult<C> failure(String requestId, Throwable error, C correlationMetadata) {
        return new SqsSenderResult<C>(requestId, null, Objects.requireNonNull(error), correlationMetadata);
    }

    public String toString() {
        return "SqsSenderResult{requestId='" + this.requestId + '\'' + ", successMetadata=" + this.successMetadata + ", error=" + this.error + ", correlationMetadata=" + this.correlationMetadata + '}';
    }

    public Optional<Throwable> failureCause() {
        return Optional.ofNullable(this.error);
    }

    public <R> SqsSenderResult<R> replaceCorrelationMetadata(R newCorrelationMetadata) {
        return new SqsSenderResult<R>(this.requestId, this.successMetadata, this.error, newCorrelationMetadata);
    }

    public <R> SqsSenderResult<R> mapCorrelationMetadata(Function<? super C, ? extends R> mapper) {
        return new SqsSenderResult<R>(this.requestId, this.successMetadata, this.error, mapper.apply(this.correlationMetadata));
    }

    public String requestId() {
        return this.requestId;
    }

    public Optional<SuccessMetadata> successMetadata() {
        return Optional.ofNullable(this.successMetadata);
    }

    public C correlationMetadata() {
        return this.correlationMetadata;
    }

    public static final class SuccessMetadata {
        private final String messageId;
        private final String sequenceNumber;

        private SuccessMetadata(String messageId, String sequenceNumber) {
            this.messageId = Objects.requireNonNull(messageId);
            this.sequenceNumber = sequenceNumber;
        }

        public String messageId() {
            return this.messageId;
        }

        public Optional<String> sequenceNumber() {
            return Optional.ofNullable(this.sequenceNumber);
        }
    }
}

