/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import io.atleon.aws.sqs.AbstractSqsMessage;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeValue;

public final class SqsSenderMessage<C>
extends AbstractSqsMessage<String> {
    private final String requestId;
    private final String messageDeduplicationId;
    private final String messageGroupId;
    private final Integer delaySeconds;
    private final C correlationMetadata;

    private SqsSenderMessage(String requestId, String messageDeduplicationId, String messageGroupId, Map<String, MessageAttributeValue> messageAttributes, Map<String, MessageSystemAttributeValue> messageSystemAttributes, String body, Integer delaySeconds, C correlationMetadata) {
        super(messageAttributes, messageSystemAttributes, body);
        this.requestId = requestId;
        this.messageDeduplicationId = messageDeduplicationId;
        this.messageGroupId = messageGroupId;
        this.delaySeconds = delaySeconds;
        this.correlationMetadata = correlationMetadata;
    }

    public static <C> Builder<C> newBuilder() {
        return new Builder(UUID.randomUUID().toString());
    }

    public String requestId() {
        return this.requestId;
    }

    @Override
    public Optional<String> messageDeduplicationId() {
        return Optional.ofNullable(this.messageDeduplicationId);
    }

    @Override
    public Optional<String> messageGroupId() {
        return Optional.ofNullable(this.messageGroupId);
    }

    @Override
    public Optional<Integer> senderDelaySeconds() {
        return Optional.ofNullable(this.delaySeconds);
    }

    public C correlationMetadata() {
        return this.correlationMetadata;
    }

    public static final class Builder<C> {
        private final String requestId;
        private String messageDeduplicationId;
        private String messageGroupId;
        private Map<String, MessageAttributeValue> messageAttributes;
        private Map<String, MessageSystemAttributeValue> messageSystemAttributes;
        private String body;
        private Integer delaySeconds;
        private C correlationMetadata;

        private Builder(String requestId) {
            this.requestId = requestId;
        }

        public SqsSenderMessage<C> build() {
            return new SqsSenderMessage(this.requestId, this.messageDeduplicationId, this.messageGroupId, this.messageAttributes, this.messageSystemAttributes, this.body, this.delaySeconds, this.correlationMetadata);
        }

        public Builder<C> messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public Builder<C> messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public Builder<C> messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = messageAttributes;
            return this;
        }

        public Builder<C> messageSystemAttributes(Map<String, MessageSystemAttributeValue> messageSystemAttributes) {
            this.messageSystemAttributes = messageSystemAttributes;
            return this;
        }

        public Builder<C> body(String body) {
            this.body = body;
            return this;
        }

        public Builder<C> delaySeconds(Integer delaySeconds) {
            this.delaySeconds = delaySeconds;
            return this;
        }

        public Builder<C> correlationMetadata(C correlationMetadata) {
            this.correlationMetadata = correlationMetadata;
            return this;
        }
    }
}

