/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;

public final class SqsReceiverOptions {
    public static final int DEFAULT_MAX_MESSAGES_PER_RECEPTION = 10;
    public static final int DEFAULT_WAIT_TIME_SECONDS_PER_RECEPTION = 5;
    public static final int DEFAULT_VISIBILITY_TIMEOUT_SECONDS = 30;
    public static final int DEFAULT_MAX_IN_FLIGHT_PER_SUBSCRIPTION = 4096;
    public static final int DEFAULT_DELETE_BATCH_SIZE = 10;
    public static final Duration DEFAULT_DELETE_INTERVAL = Duration.ofSeconds(1L);
    public static final Duration DEFAULT_CLOSE_TIMEOUT = Duration.ofSeconds(10L);
    private final Supplier<SqsAsyncClient> clientSupplier;
    private final int maxMessagesPerReception;
    private final Set<String> messageAttributesToRequest;
    private final Set<String> messageSystemAttributesToRequest;
    private final int waitTimeSecondsPerReception;
    private final int visibilityTimeoutSeconds;
    private final int maxInFlightPerSubscription;
    private final int deleteBatchSize;
    private final Duration deleteInterval;
    private final Duration closeTimeout;

    private SqsReceiverOptions(Supplier<SqsAsyncClient> clientSupplier, int maxMessagesPerReception, Set<String> messageAttributesToRequest, Set<String> messageSystemAttributesToRequest, int waitTimeSecondsPerReception, int visibilityTimeoutSeconds, int maxInFlightPerSubscription, int deleteBatchSize, Duration deleteInterval, Duration closeTimeout) {
        this.clientSupplier = clientSupplier;
        this.maxMessagesPerReception = maxMessagesPerReception;
        this.messageAttributesToRequest = messageAttributesToRequest;
        this.messageSystemAttributesToRequest = messageSystemAttributesToRequest;
        this.waitTimeSecondsPerReception = waitTimeSecondsPerReception;
        this.visibilityTimeoutSeconds = visibilityTimeoutSeconds;
        this.maxInFlightPerSubscription = maxInFlightPerSubscription;
        this.deleteBatchSize = deleteBatchSize;
        this.deleteInterval = deleteInterval;
        this.closeTimeout = closeTimeout;
    }

    public static SqsReceiverOptions defaultOptions(Supplier<SqsAsyncClient> clientSupplier) {
        return SqsReceiverOptions.newBuilder(clientSupplier).build();
    }

    public static Builder newBuilder(Supplier<SqsAsyncClient> clientSupplier) {
        return new Builder(clientSupplier);
    }

    public SqsAsyncClient createClient() {
        return this.clientSupplier.get();
    }

    public int maxMessagesPerReception() {
        return this.maxMessagesPerReception;
    }

    public Set<String> messageAttributesToRequest() {
        return this.messageAttributesToRequest;
    }

    public Set<String> messageSystemAttributesToRequest() {
        return this.messageSystemAttributesToRequest;
    }

    public int waitTimeSecondsPerReception() {
        return this.waitTimeSecondsPerReception;
    }

    public int visibilityTimeoutSeconds() {
        return this.visibilityTimeoutSeconds;
    }

    public int maxInFlightPerSubscription() {
        return this.maxInFlightPerSubscription;
    }

    public int deleteBatchSize() {
        return this.deleteBatchSize;
    }

    public Duration deleteInterval() {
        return this.deleteInterval;
    }

    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    public static final class Builder {
        private final Supplier<SqsAsyncClient> clientSupplier;
        private int maxMessagesPerReception = 10;
        private Set<String> messageAttributesToRequest = Collections.emptySet();
        private Set<String> messageSystemAttributesToRequest = Collections.emptySet();
        private int waitTimeSecondsPerReception = 5;
        private int visibilityTimeoutSeconds = 30;
        private int maxInFlightPerSubscription = 4096;
        private int deleteBatchSize = 10;
        private Duration deleteInterval = DEFAULT_DELETE_INTERVAL;
        private Duration closeTimeout = DEFAULT_CLOSE_TIMEOUT;

        private Builder(Supplier<SqsAsyncClient> clientSupplier) {
            this.clientSupplier = clientSupplier;
        }

        public SqsReceiverOptions build() {
            return new SqsReceiverOptions(this.clientSupplier, this.maxMessagesPerReception, this.messageAttributesToRequest, this.messageSystemAttributesToRequest, this.waitTimeSecondsPerReception, this.visibilityTimeoutSeconds, this.maxInFlightPerSubscription, this.deleteBatchSize, this.deleteInterval, this.closeTimeout);
        }

        public Builder maxMessagesPerReception(int maxMessagesPerReception) {
            if (maxMessagesPerReception < 1 || maxMessagesPerReception > 10) {
                throw new IllegalArgumentException("maxMessagesPerReception must be 1-10, got " + maxMessagesPerReception);
            }
            this.maxMessagesPerReception = maxMessagesPerReception;
            return this;
        }

        public Builder messageAttributesToRequest(Set<String> messageAttributesToRequest) {
            this.messageAttributesToRequest = messageAttributesToRequest;
            return this;
        }

        public Builder messageSystemAttributesToRequest(Set<String> messageSystemAttributesToRequest) {
            this.messageSystemAttributesToRequest = messageSystemAttributesToRequest;
            return this;
        }

        public Builder waitTimeSecondsPerReception(int waitTimeSecondsPerReception) {
            this.waitTimeSecondsPerReception = waitTimeSecondsPerReception;
            return this;
        }

        public Builder visibilityTimeoutSeconds(int visibilityTimeoutSeconds) {
            this.visibilityTimeoutSeconds = visibilityTimeoutSeconds;
            return this;
        }

        public Builder maxInFlightPerSubscription(int maxInFlightPerSubscription) {
            this.maxInFlightPerSubscription = maxInFlightPerSubscription;
            return this;
        }

        public Builder deleteBatchSize(int deleteBatchSize) {
            this.deleteBatchSize = deleteBatchSize;
            return this;
        }

        public Builder deleteInterval(Duration deleteInterval) {
            this.deleteInterval = deleteInterval;
            return this;
        }

        public Builder closeTimeout(Duration closeTimeout) {
            this.closeTimeout = closeTimeout;
            return this;
        }
    }
}

