/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import io.atleon.aws.sqs.AloReceivedSqsMessageDecorator;
import io.atleon.aws.sqs.ReceivedSqsMessage;
import io.atleon.aws.util.AwsConfig;
import io.atleon.core.AloFactory;
import io.atleon.core.AloFactoryConfig;
import io.atleon.util.ConfigLoading;
import io.atleon.util.Configurable;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;

public class SqsConfig {
    public static final String ENDPOINT_OVERRIDE_CONFIG = "sqs.endpoint.override";
    private final Map<String, ?> properties;

    private SqsConfig(Map<String, ?> properties) {
        this.properties = properties;
    }

    public static SqsConfig fromMap(Map<String, ?> map) {
        return new SqsConfig(Collections.unmodifiableMap(new HashMap(map)));
    }

    public SqsAsyncClient buildClient() {
        return (SqsAsyncClient)((SqsAsyncClientBuilder)((SqsAsyncClientBuilder)((SqsAsyncClientBuilder)SqsAsyncClient.builder().endpointOverride((URI)ConfigLoading.loadUri(this.properties, (String)ENDPOINT_OVERRIDE_CONFIG).orElse(null))).credentialsProvider(AwsConfig.loadCredentialsProvider(this.properties))).region((Region)AwsConfig.loadRegion(this.properties).orElse(null))).build();
    }

    public <T> AloFactory<ReceivedSqsMessage<T>> loadAloFactory() {
        return AloFactoryConfig.loadDecorated(this.properties, AloReceivedSqsMessageDecorator.class);
    }

    public <T extends Configurable> T loadConfiguredOrThrow(String property, Class<? extends T> type) {
        return (T)ConfigLoading.loadConfiguredOrThrow(this.properties, (String)property, type);
    }

    public Set<String> loadSetOfStringOrEmpty(String key) {
        return ConfigLoading.loadSetOfStringOrEmpty(this.properties, (String)key);
    }

    public <T extends Configurable> Optional<T> loadConfiguredWithPredefinedTypes(String key, Class<? extends T> type, Function<String, Optional<T>> predefinedTypeInstantiator) {
        return ConfigLoading.loadConfiguredWithPredefinedTypes(this.properties, (String)key, type, predefinedTypeInstantiator);
    }

    public Optional<Duration> loadDuration(String key) {
        return ConfigLoading.loadDuration(this.properties, (String)key);
    }

    public Optional<Integer> loadInt(String key) {
        return ConfigLoading.loadInt(this.properties, (String)key);
    }
}

