/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import io.atleon.aws.sqs.AbstractSqsMessage;
import io.atleon.aws.sqs.ReceivedSqsMessage;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeValue;

public final class DeserializedSqsMessage<T>
extends AbstractSqsMessage<T>
implements ReceivedSqsMessage<T> {
    private final String receiptHandle;
    private final String messageId;

    private DeserializedSqsMessage(String receiptHandle, String messageId, Map<String, MessageAttributeValue> messageAttributes, Map<String, MessageSystemAttributeValue> messageSystemAttributes, T body) {
        super(messageAttributes, messageSystemAttributes, body);
        this.receiptHandle = receiptHandle;
        this.messageId = messageId;
    }

    public static <T> DeserializedSqsMessage<T> create(String receiptHandle, String messageId, Map<String, MessageAttributeValue> messageAttributes, Map<String, MessageSystemAttributeValue> messageSystemAttributes, T body) {
        return new DeserializedSqsMessage<T>(receiptHandle, messageId, messageAttributes, messageSystemAttributes, body);
    }

    @Override
    public String messageId() {
        return this.messageId;
    }

    @Override
    public String receiptHandle() {
        return this.receiptHandle;
    }

    @Override
    public Optional<String> messageDeduplicationId() {
        return this.messageSystemAttribute(MessageSystemAttributeName.MESSAGE_DEDUPLICATION_ID).map(MessageSystemAttributeValue::stringValue);
    }

    @Override
    public Optional<String> messageGroupId() {
        return this.messageSystemAttribute(MessageSystemAttributeName.MESSAGE_GROUP_ID).map(MessageSystemAttributeValue::stringValue);
    }
}

