/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import io.atleon.aws.sqs.AbstractSqsMessage;
import io.atleon.aws.sqs.SqsMessage;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeValue;

public final class ComposedSqsMessage<T>
extends AbstractSqsMessage<T> {
    private final String messageDeduplicationId;
    private final String messageGroupId;
    private final Integer senderDelaySeconds;

    private ComposedSqsMessage(String messageDeduplicationId, String messageGroupId, Map<String, MessageAttributeValue> messageAttributes, Map<String, MessageSystemAttributeValue> messageSystemAttributes, T body, Integer senderDelaySeconds) {
        super(messageAttributes, messageSystemAttributes, body);
        this.messageDeduplicationId = messageDeduplicationId;
        this.messageGroupId = messageGroupId;
        this.senderDelaySeconds = senderDelaySeconds;
    }

    public static <T> SqsMessage<T> fromBody(T body) {
        return ComposedSqsMessage.newBuilder(body).build();
    }

    public static <T> Builder<T> newBuilder(T body) {
        return ComposedSqsMessage.newBuilder().body(body);
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    @Override
    public Optional<String> messageDeduplicationId() {
        return Optional.ofNullable(this.messageDeduplicationId);
    }

    @Override
    public Optional<String> messageGroupId() {
        return Optional.ofNullable(this.messageGroupId);
    }

    @Override
    public Optional<Integer> senderDelaySeconds() {
        return Optional.ofNullable(this.senderDelaySeconds);
    }

    public static final class Builder<T> {
        private String messageDeduplicationId;
        private String messageGroupId;
        private Map<String, MessageAttributeValue> messageAttributes = Collections.emptyMap();
        private Map<String, MessageSystemAttributeValue> messageSystemAttributes = Collections.emptyMap();
        private T body;
        private Integer senderDelaySeconds;

        private Builder() {
        }

        public ComposedSqsMessage<T> build() {
            return new ComposedSqsMessage(this.messageDeduplicationId, this.messageGroupId, this.messageAttributes, this.messageSystemAttributes, this.body, this.senderDelaySeconds);
        }

        public Builder<T> messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public Builder<T> messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public Builder<T> messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = messageAttributes;
            return this;
        }

        public Builder<T> messageSystemAttributes(Map<String, MessageSystemAttributeValue> messageSystemAttributes) {
            this.messageSystemAttributes = messageSystemAttributes;
            return this;
        }

        public Builder<T> body(T body) {
            this.body = body;
            return this;
        }

        public Builder<T> senderDelaySeconds(Integer senderDelaySeconds) {
            this.senderDelaySeconds = senderDelaySeconds;
            return this;
        }
    }
}

