/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.aws.sqs;

import io.atleon.aws.sqs.SqsMessage;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeValue;

public abstract class AbstractSqsMessage<T>
implements SqsMessage<T> {
    private final Map<String, MessageAttributeValue> messageAttributes;
    private final Map<String, MessageSystemAttributeValue> messageSystemAttributes;
    private final T body;

    protected AbstractSqsMessage(Map<String, MessageAttributeValue> messageAttributes, Map<String, MessageSystemAttributeValue> messageSystemAttributes, T body) {
        this.messageAttributes = messageAttributes;
        this.messageSystemAttributes = messageSystemAttributes;
        this.body = body;
    }

    @Override
    public final Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public final Optional<MessageSystemAttributeValue> messageSystemAttribute(MessageSystemAttributeName key) {
        return this.messageSystemAttribute(key.toString());
    }

    public final Optional<MessageSystemAttributeValue> messageSystemAttribute(String key) {
        return Optional.ofNullable(this.messageSystemAttributes.get(key));
    }

    @Override
    public final Map<String, MessageSystemAttributeValue> messageSystemAttributes() {
        return this.messageSystemAttributes;
    }

    @Override
    public final T body() {
        return this.body;
    }
}

