package io.atlassian.blobstore.client.api;

import com.google.common.base.Function;

/**
 * The result of a put operation call on a BlobstoreService
 */
public final class PutResult {
  public static enum Status {
    CREATED, UPDATED
  }

  public static PutResult updated(final String hash) {
    return new PutResult(Status.UPDATED, hash);
  }

  public static PutResult created(final String hash) {
    return new PutResult(Status.CREATED, hash);
  }

  public static final Function<String, PutResult> CREATED = new Function<String, PutResult>() {
    @Override public PutResult apply(String input) {
      return created(input);
    }
  };

  public static final Function<String, PutResult> UPDATED = new Function<String, PutResult>() {
    @Override public PutResult apply(String input) {
      return updated(input);
    }
  };

  private final Status status;
  private final String hash;

  PutResult(final Status status, final String hash) {
    this.status = status;
    this.hash = hash;
  }

  public String hash() {
    return hash;
  }

  public Status status() {
    return status;
  }

  @Override public boolean equals(final Object o) {
    if (this == o)
      return true;
    if (o == null || getClass() != o.getClass())
      return false;

    PutResult putResult = (PutResult) o;

    if (!hash.equals(putResult.hash))
      return false;
    if (status != putResult.status)
      return false;

    return true;
  }

  @Override public int hashCode() {
    return 31 * status.hashCode() + hash.hashCode();
  }

  @Override public String toString() {
    return "PutResult{" + "status=" + status + ", hash='" + hash + '\'' + '}';
  }
}
