package io.atlassian.blobstore.client.api;

/**
 * The result of a head operation call on a BlobstoreService
 */
public final class HeadResult {

  public static HeadResult create(final String hash, final long contentLength) {
    return new HeadResult(hash, contentLength);
  }

  private final String hash;
  private final long contentLength;

  HeadResult(final String hash, final long contentLength) {
    this.hash = hash;
    this.contentLength = contentLength;
  }

  public String hash() {
    return hash;
  }

  public long contentLength() {
    return contentLength;
  }

  @Override
  public String toString() {
    return "HeadResult{" +
        "hash='" + hash + '\'' +
        ", contentLength=" + contentLength +
        '}';
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    HeadResult that = (HeadResult) o;

    if (contentLength != that.contentLength) return false;
    if (!hash.equals(that.hash)) return false;

    return true;
  }

  @Override
  public int hashCode() {
    int result = hash.hashCode();
    result = 31 * result + (int) (contentLength ^ (contentLength >>> 32));
    return result;
  }
}
