package io.atlassian.blobstore.client.api;

import java.io.InputStream;

/**
 * The result of a get operation call on a BlobstoreService
 */
public final class GetResult {

  public static GetResult create(final InputStream data, final HeadResult head) {
    return new GetResult(data, head);
  }

  private final InputStream data;
  private final HeadResult head;

  GetResult(final InputStream data, final HeadResult head) {
    this.data = data;
    this.head = head;
  }

  public InputStream data() {
    return data;
  }

  public HeadResult head() {
    return head;
  }
}
