package io.atlassian.blobstore.client.api;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * A Key is an address for a blob. It is immutable, and the blob it represents
 * cannot change.
 * <p>
 * A modification to a logical blob yields a new blob with a different key. A
 * key is not an identity for a logical entity.
 */
public final class ContentKey
{
  public static ContentKey create(final String hash) {
    return new ContentKey(hash);
  }

  private final String hash;

  ContentKey(final String hash) {
    this.hash = checkNotNull(hash);
  }

  public String base16() {
    return hash;
  }

  @Override public int hashCode() {
    return hash.hashCode();
  }

  @Override public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    return hash.equals(((ContentKey) obj).hash);
  }

  @Override public String toString() {
    return hash;
  }
}
