package io.atlassian.blobstore.client.api;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;

/**
 * Interface to a configuration service for configuring the blobstore client and cross-product settings related to
 * blob storage.
 */
public interface ConfigService {

  /**
   * Set the URI for the blobstore server.
   * 
   * @param uri The URI for the blobstore server, if there is one.
   * @return either the successfully set.
   */
  Either<Throwable, Option<String>> setBlobstoreUri(Option<String> uri);

  /**
   * @return The current URI for the blobstore server.
   */
  Option<String> blobstoreUri();

  /**
   * Set the 'usage mode' for blobstore. See {@link io.atlassian.blobstore.client.api.BlobStoreUsage} for options. This
   * saved to the application's dark feature store.
   *
   * @param usage The usage mode.
   */
  void setBlobStoreUsage(BlobStoreUsage usage);

  /**
   * The current 'usage mode' for blobstore. See {@link io.atlassian.blobstore.client.api.BlobStoreUsage} for valid values.
   * @return The current usage mode.
   */
  BlobStoreUsage blobStoreUsage();
}
