package io.atlassian.blobstore.client.api;

/**
 * Represents stages of an application's usage of BlobStore. It is expected that an application would transition from
 * NONE (i.e. local existing implementation, no blobstore), to SECONDARY (blobstore written to asynchronously), to
 * PRIMARY_WITH_FALLBACK (blobstore written synchronously, retrieval from local if present), and then PRIMARY (blobstore
 * only).
 */
public enum BlobStoreUsage {
    // TODO - change to cross product flags
    NONE("com.atlassian.jira.FS_ATTACHMENTS_ONLY"),
    SECONARY("com.atlassian.jira.FS_ATTACHMENTS_PRIMARY"),
    PRIMARY_WITH_FALLBACK("com.atlassian.jira.REMOTE_ATTACHMENTS_PRIMARY"),
    PRIMARY("com.atlassian.jira.REMOTE_ONLY");

    private String featureFlag;

    public String getFeatureFlag() {
        return featureFlag;
    }

    private BlobStoreUsage(final String featureFlag) {
        this.featureFlag = featureFlag;
    }
}