package io.atlassian.blobstore.client.api;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Hints for accessing blobs in the store.
 */
public final class Access {

  public static Builder builder() {
    return new Builder();
  }

  private final CacheControl cacheControl;

  Access(final CacheControl cacheControl) {
    this.cacheControl = checkNotNull(cacheControl);
  }

  public CacheControl cacheControl() {
    return cacheControl;
  }

  @Override
  public String toString() {
      return "Access{cacheControl=" + cacheControl + '}';
  }

  public static enum CacheControl {
    FOREVER, NOCACHE, LOCAL
  }

  public static final class Builder {
    CacheControl cacheControl = CacheControl.FOREVER;

    Builder() {}

    public Access build() {
      return new Access(cacheControl);
    }

    public Builder setCacheControl(final CacheControl cacheControl) {
      this.cacheControl = checkNotNull(cacheControl);
      return this;
    }
  }
}
