/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.cache;

import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.cache.FreqSketch;
import io.asyncer.r2dbc.mysql.cache.Lru;
import io.asyncer.r2dbc.mysql.cache.QueryCache;
import io.asyncer.r2dbc.mysql.cache.RingBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

final class QueryBoundedCache
extends ConcurrentHashMap<String, Lru.Node<Query>>
implements QueryCache {
    private static final int READ_BUFFER_SIZE = 16;
    private static final int WRITE_BUFFER_SIZE = 32;
    private final FreqSketch sketch;
    private final RingBuffer<Lru.Node<Query>> readBuffer;
    private final RingBuffer<Lru.Node<Query>> writeBuffer;
    private final ReentrantLock lock;
    private final Lru<Query> window;
    private final Lru<Query> probation;
    private final Lru<Query> protection;

    QueryBoundedCache(int capacity) {
        int windowSize = Math.max(1, capacity / 100);
        int protectionSize = Math.max(1, (int)((double)(capacity - windowSize) * 0.8));
        int probationSize = Math.max(1, capacity - protectionSize - windowSize);
        this.sketch = new FreqSketch(windowSize + protectionSize + probationSize);
        this.readBuffer = new RingBuffer<Lru.Node>(16, 3, this::drainRead);
        this.writeBuffer = new RingBuffer<Lru.Node>(32, 50, this::drainAdded);
        this.lock = new ReentrantLock();
        this.window = new Lru(windowSize, 1);
        this.probation = new Lru(probationSize, 2);
        this.protection = new Lru(protectionSize, 3);
    }

    @Override
    public Query get(String key) {
        Lru.Node node = (Lru.Node)super.get(key);
        if (node != null) {
            this.afterRead(node);
            return (Query)node.getValue();
        }
        boolean[] present = new boolean[]{true};
        node = super.computeIfAbsent(key, k -> {
            present[0] = false;
            return new Lru.Node<Query>((String)k, Query.parse(k));
        });
        if (present[0]) {
            this.afterRead(node);
        } else {
            this.afterAdded(node);
        }
        return (Query)node.getValue();
    }

    private void afterRead(Lru.Node<Query> node) {
        boolean isFailed;
        boolean bl = isFailed = !this.readBuffer.offer(node);
        if (this.lock.tryLock()) {
            try {
                this.readBuffer.drainAll();
                if (isFailed) {
                    this.drainRead(node);
                }
                this.writeBuffer.drainAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void afterAdded(Lru.Node<Query> node) {
        if (this.writeBuffer.offer(node)) {
            if (this.lock.tryLock()) {
                try {
                    this.readBuffer.drainAll();
                    this.writeBuffer.drainAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        } else {
            this.lock.lock();
            try {
                this.readBuffer.drainAll();
                this.writeBuffer.drainAll();
                this.drainAdded(node);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void drainAdded(Lru.Node<Query> node) {
        Lru.Node<Query> evicted;
        this.sketch.increment(node.getKey().hashCode());
        Lru.Node<Query> windowEvict = this.window.push(node);
        if (windowEvict == null) {
            return;
        }
        Lru.Node<Query> probationEvict = this.probation.nextEviction();
        if (probationEvict == null) {
            this.probation.push(windowEvict);
            return;
        }
        Lru.Node<Query> node2 = evicted = this.sketch.frequency(windowEvict.getKey().hashCode()) > this.sketch.frequency(probationEvict.getKey().hashCode()) ? this.probation.push(windowEvict) : windowEvict;
        if (evicted == null) {
            return;
        }
        super.remove(evicted.getKey(), evicted);
    }

    private void drainRead(Lru.Node<Query> node) {
        this.sketch.increment(node.getKey().hashCode());
        switch (node.getLru()) {
            case 1: {
                this.window.refresh(node);
                break;
            }
            case 2: {
                this.probation.remove(node);
                Lru.Node<Query> evicted = this.protection.push(node);
                if (evicted == null) break;
                this.probation.push(evicted);
                break;
            }
            case 3: {
                this.protection.refresh(node);
            }
        }
    }
}

