/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.collation;

import io.asyncer.r2dbc.mysql.collation.AbstractCharsetTarget;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

final class NamedCharsetTarget
extends AbstractCharsetTarget {
    private final String charsetName;

    NamedCharsetTarget(int byteSize, String charsetName) {
        super(byteSize);
        this.charsetName = AssertUtils.requireNonNull(charsetName, "charsetName must not be null");
    }

    @Override
    public Charset getCharset() throws UnsupportedCharsetException {
        return Charset.forName(this.charsetName);
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedCharsetTarget)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedCharsetTarget that = (NamedCharsetTarget)o;
        return this.charsetName.equals(that.charsetName);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + this.charsetName.hashCode();
    }

    public String toString() {
        return "NamedCharsetTarget{charsetName='" + this.charsetName + "', byteSize=" + this.byteSize + '}';
    }
}

