/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.AbstractTransactionState;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.QueryLogger;
import io.asyncer.r2dbc.mysql.client.FluxExchangeable;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.asyncer.r2dbc.mysql.message.client.PingMessage;
import io.asyncer.r2dbc.mysql.message.client.TextQueryMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import java.util.Iterator;
import java.util.Queue;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Sinks;
import reactor.core.publisher.SynchronousSink;
import reactor.util.concurrent.Queues;

final class TransactionMultiExchangeable
extends FluxExchangeable<Void> {
    private final Sinks.Many<ClientMessage> requests = Sinks.many().unicast().onBackpressureBuffer((Queue)Queues.one().get());
    private final AbstractTransactionState state;
    private final Iterator<String> statements;

    TransactionMultiExchangeable(AbstractTransactionState state) {
        this.state = state;
        this.statements = state.statements();
    }

    @Override
    public void accept(ServerMessage message, SynchronousSink<Void> sink) {
        if (this.state.accept(message, sink)) {
            String sql = this.statements.next();
            QueryLogger.log(sql);
            this.state.setSql(sql);
            Sinks.EmitResult result = this.requests.tryEmitNext((Object)new TextQueryMessage(sql));
            if (result != Sinks.EmitResult.OK) {
                QueryFlow.logger.error("Fail to emit a transaction message due to {}", (Object)result);
                sink.complete();
            }
        }
    }

    public void dispose() {
        this.requests.tryEmitComplete();
    }

    public void subscribe(CoreSubscriber<? super ClientMessage> s) {
        if (this.state.cancelTasks()) {
            s.onSubscribe(Operators.scalarSubscription(s, (Object)PingMessage.INSTANCE));
            return;
        }
        String sql = this.statements.next();
        QueryLogger.log(sql);
        this.state.setSql(sql);
        this.requests.asFlux().subscribe(s);
        Sinks.EmitResult result = this.requests.tryEmitNext((Object)new TextQueryMessage(sql));
        if (result != Sinks.EmitResult.OK) {
            QueryFlow.logger.error("Fail to emit a transaction message due to {}", (Object)result);
        }
    }
}

