/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.extension.Extension;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;

final class Extensions {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Extensions.class);
    private static final Extension[] EMPTY = new Extension[0];
    private final Extension[] extensions;

    private Extensions(List<Extension> extensions) {
        this.extensions = Extensions.toArray(extensions);
    }

    <T extends Extension> void forEach(Class<T> type, Consumer<? super T> consumer) {
        for (Extension extension : this.extensions) {
            if (!type.isInstance(extension)) continue;
            consumer.accept(type.cast(extension));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extensions that = (Extensions)o;
        return Arrays.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.extensions);
    }

    public String toString() {
        return "Extensions" + Arrays.toString(this.extensions);
    }

    static Extensions from(List<Extension> extensions, boolean autodetect) {
        if (autodetect) {
            return new Extensions(Extensions.autodetect(new ArrayList<Extension>(extensions)));
        }
        return new Extensions(extensions);
    }

    private static List<Extension> autodetect(List<Extension> discovered) {
        logger.debug("Discovering Extensions using ServiceLoader");
        ServiceLoader extensions = AccessController.doPrivileged(() -> ServiceLoader.load(Extension.class, Extensions.class.getClassLoader()));
        for (Extension extension : extensions) {
            logger.debug(String.format("Registering extension %s", extension.getClass().getName()));
            discovered.add(extension);
        }
        return discovered;
    }

    private static Extension[] toArray(List<Extension> extensions) {
        if (extensions.isEmpty()) {
            return EMPTY;
        }
        return extensions.toArray(new Extension[0]);
    }
}

