/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.AbstractTransactionState;
import io.asyncer.r2dbc.mysql.ConnectionState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.SynchronousSink;

final class CommitRollbackState
extends AbstractTransactionState {
    private static final int LOCK_WAIT_TIMEOUT = 1;
    private static final int COMMIT_OR_ROLLBACK = 2;

    private CommitRollbackState(ConnectionState state, int tasks, List<String> statements) {
        super(state, tasks, statements);
    }

    @Override
    boolean cancelTasks() {
        if (this.state.isInTransaction()) {
            return false;
        }
        this.tasks = 2;
        return true;
    }

    @Override
    protected boolean process(int task, SynchronousSink<Void> sink) {
        switch (task) {
            case 1: {
                this.state.resetCurrentLockWaitTimeout();
                return true;
            }
            case 2: {
                this.state.resetIsolationLevel();
                sink.complete();
                return false;
            }
        }
        sink.error((Throwable)new IllegalStateException("Undefined commit task: " + task + ", remain: " + this.tasks));
        return false;
    }

    static CommitRollbackState of(ConnectionState state, boolean commit, long lockWaitTimeout) {
        String doneSql;
        String string = doneSql = commit ? "COMMIT" : "ROLLBACK";
        if (state.isLockWaitTimeoutChanged()) {
            ArrayList<String> statements = new ArrayList<String>(2);
            statements.add("SET innodb_lock_wait_timeout=" + lockWaitTimeout);
            statements.add(doneSql);
            return new CommitRollbackState(state, 3, statements);
        }
        return new CommitRollbackState(state, 2, Collections.singletonList(doneSql));
    }
}

