/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

public final class Capability {
    private static final int LONG_PASSWORD = 1;
    private static final int FOUND_ROWS = 2;
    private static final int LONG_FLAG = 4;
    private static final int CONNECT_WITH_DB = 8;
    private static final int NO_SCHEMA = 16;
    private static final int COMPRESS = 32;
    private static final int LOCAL_FILES = 128;
    private static final int IGNORE_SPACE = 256;
    private static final int PROTOCOL_41 = 512;
    private static final int INTERACTIVE = 1024;
    private static final int SSL = 2048;
    private static final int TRANSACTIONS = 8192;
    private static final int SECURE_SALT = 32768;
    private static final int MULTI_STATEMENTS = 65536;
    private static final int MULTI_RESULTS = 131072;
    private static final int PS_MULTI_RESULTS = 262144;
    private static final int PLUGIN_AUTH = 524288;
    private static final int CONNECT_ATTRS = 0x100000;
    private static final int VAR_INT_SIZED_AUTH = 0x200000;
    private static final int DEPRECATE_EOF = 0x1000000;
    private static final int ALL_SUPPORTED = 20950975;
    private final int bitmap;

    public boolean isConnectWithDatabase() {
        return (this.bitmap & 8) != 0;
    }

    public boolean isSslEnabled() {
        return (this.bitmap & 0x800) != 0;
    }

    public boolean isProtocol41() {
        return (this.bitmap & 0x200) != 0;
    }

    public boolean isVarIntSizedAuthAllowed() {
        return (this.bitmap & 0x200000) != 0;
    }

    public boolean isPluginAuthAllowed() {
        return (this.bitmap & 0x80000) != 0;
    }

    public boolean isConnectionAttributesAllowed() {
        return (this.bitmap & 0x100000) != 0;
    }

    public boolean isMultiStatementsAllowed() {
        return (this.bitmap & 0x10000) != 0;
    }

    public boolean isEofDeprecated() {
        return (this.bitmap & 0x1000000) != 0;
    }

    public boolean isSaltSecured() {
        return (this.bitmap & 0x8000) != 0;
    }

    public boolean isTransactionAllowed() {
        return (this.bitmap & 0x2000) != 0;
    }

    public int getBitmap() {
        return this.bitmap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capability)) {
            return false;
        }
        Capability that = (Capability)o;
        return this.bitmap == that.bitmap;
    }

    public int hashCode() {
        return this.bitmap;
    }

    public String toString() {
        return "Capability<0x" + Integer.toHexString(this.bitmap) + '>';
    }

    Builder mutate() {
        return new Builder(this.bitmap);
    }

    private Capability(int bitmap) {
        this.bitmap = bitmap;
    }

    public static Capability of(int capabilities) {
        return new Capability(capabilities & 0x13FAFBF);
    }

    static final class Builder {
        private int bitmap;

        void disableConnectWithDatabase() {
            this.bitmap &= 0xFFFFFFF7;
        }

        void disableDatabasePinned() {
            this.bitmap &= 0xFFFFFFEF;
        }

        void disableCompression() {
            this.bitmap &= 0xFFFFFFDF;
        }

        void disableLoadDataInfile() {
            this.bitmap &= 0xFFFFFF7F;
        }

        void disableIgnoreAmbiguitySpace() {
            this.bitmap &= 0xFFFFFEFF;
        }

        void disableInteractiveTimeout() {
            this.bitmap &= 0xFFFFFBFF;
        }

        void disableSsl() {
            this.bitmap &= 0xFFFFF7FF;
        }

        void disableConnectAttributes() {
            this.bitmap &= 0xFFEFFFFF;
        }

        Capability build() {
            return Capability.of(this.bitmap);
        }

        private Builder(int bitmap) {
            this.bitmap = bitmap;
        }
    }
}

