/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.asyncer.r2dbc.mysql.util.OperatorUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public final class PreparedExecuteMessage
implements ClientMessage,
Disposable {
    private static final byte NO_CURSOR = 0;
    private static final byte READ_ONLY = 1;
    private static final int NO_PARAM_SIZE = 10;
    private static final int TIMES = 1;
    private static final byte EXECUTE_FLAG = 23;
    private static final Consumer<MySqlParameter> DISPOSE = MySqlParameter::dispose;
    private final int statementId;
    private final boolean immediate;
    private final MySqlParameter[] values;

    public PreparedExecuteMessage(int statementId, boolean immediate, MySqlParameter[] values) {
        this.values = AssertUtils.requireNonNull(values, "values must not be null");
        this.statementId = statementId;
        this.immediate = immediate;
    }

    public void dispose() {
        for (MySqlParameter value : this.values) {
            value.dispose();
        }
        Arrays.fill(this.values, null);
    }

    public String toString() {
        return "PreparedExecuteMessage{statementId=" + this.statementId + ", immediate=" + this.immediate + ", has " + this.values.length + " parameters}";
    }

    public Flux<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        return Flux.defer(() -> {
            int size = this.values.length;
            ByteBuf buf = size == 0 ? allocator.buffer(10) : allocator.buffer();
            try {
                buf.writeByte(23).writeIntLE(this.statementId).writeByte(this.immediate ? 0 : 1).writeIntLE(1);
                if (size == 0) {
                    return Flux.just((Object)buf);
                }
                ArrayList<MySqlParameter> nonNull = new ArrayList<MySqlParameter>(size);
                byte[] nullMap = this.fillNullBitmap(size, nonNull);
                buf.writeBytes(nullMap);
                if (nonNull.isEmpty()) {
                    buf.writeBoolean(false);
                    return Flux.just((Object)buf);
                }
                buf.writeBoolean(true);
                this.writeTypes(buf, size);
                Flux parameters = OperatorUtils.discardOnCancel(Flux.fromArray((Object[])this.values)).doOnDiscard(MySqlParameter.class, DISPOSE).concatMap(MySqlParameter::publishBinary);
                return Flux.just((Object)buf).concatWith((Publisher)parameters);
            }
            catch (Throwable e) {
                buf.release();
                this.cancelParameters();
                return Flux.error((Throwable)e);
            }
        });
    }

    private byte[] fillNullBitmap(int size, List<MySqlParameter> nonNull) {
        byte[] nullMap = new byte[PreparedExecuteMessage.ceilDiv8(size)];
        for (int i = 0; i < size; ++i) {
            MySqlParameter value = this.values[i];
            if (value.isNull()) {
                int n = i >> 3;
                nullMap[n] = (byte)(nullMap[n] | 1 << (i & 7));
                continue;
            }
            nonNull.add(value);
        }
        return nullMap;
    }

    private void writeTypes(ByteBuf buf, int size) {
        for (int i = 0; i < size; ++i) {
            buf.writeShortLE(this.values[i].getType().getId());
        }
    }

    private void cancelParameters() {
        for (MySqlParameter value : this.values) {
            value.dispose();
        }
    }

    private static int ceilDiv8(int x) {
        int r = x >> 3;
        return r << 3 == x ? r : r + 1;
    }
}

