/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.message.client.LoginClientMessage;
import io.asyncer.r2dbc.mysql.message.client.SizedClientMessage;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;

public final class AuthResponse
extends SizedClientMessage
implements LoginClientMessage {
    private final int envelopeId;
    private final byte[] authentication;

    public AuthResponse(int envelopeId, byte[] authentication) {
        this.envelopeId = envelopeId;
        this.authentication = AssertUtils.requireNonNull(authentication, "authentication must not be null");
    }

    @Override
    public int getEnvelopeId() {
        return this.envelopeId;
    }

    @Override
    protected int size() {
        return this.authentication.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthResponse that = (AuthResponse)o;
        return this.envelopeId == that.envelopeId && Arrays.equals(this.authentication, that.authentication);
    }

    public int hashCode() {
        return 31 * this.envelopeId + Arrays.hashCode(this.authentication);
    }

    public String toString() {
        return "AuthResponse{envelopeId=" + this.envelopeId + ", authentication=REDACTED}";
    }

    @Override
    protected void writeTo(ByteBuf buf) {
        buf.writeBytes(this.authentication);
    }
}

