/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.cache;

import io.asyncer.r2dbc.mysql.cache.FreqSketch;
import io.asyncer.r2dbc.mysql.cache.Lru;
import io.asyncer.r2dbc.mysql.cache.PrepareCache;
import java.util.HashMap;
import java.util.function.IntConsumer;

final class PrepareBoundedCache
extends HashMap<String, Lru.Node<Integer>>
implements PrepareCache {
    private final FreqSketch sketch;
    private final Lru<Integer> window;
    private final Lru<Integer> probation;
    private final Lru<Integer> protection;

    PrepareBoundedCache(int capacity) {
        int windowSize = Math.max(1, capacity / 100);
        int protectionSize = Math.max(1, (int)((double)(capacity - windowSize) * 0.8));
        int probationSize = Math.max(1, capacity - protectionSize - windowSize);
        this.sketch = new FreqSketch(windowSize + protectionSize + probationSize);
        this.window = new Lru(windowSize, 1);
        this.probation = new Lru(probationSize, 2);
        this.protection = new Lru(protectionSize, 3);
    }

    @Override
    public synchronized Integer getIfPresent(String key) {
        Lru.Node node = (Lru.Node)super.get(key);
        if (node == null) {
            return null;
        }
        this.drainRead(node);
        return (Integer)node.getValue();
    }

    @Override
    public synchronized boolean putIfAbsent(String key, int value, IntConsumer evict) {
        Lru.Node<Integer> wantAdd = new Lru.Node<Integer>(key, value);
        Lru.Node<Integer> present = super.putIfAbsent(key, wantAdd);
        if (present == null) {
            this.drainAdded(wantAdd, evict);
            return true;
        }
        this.drainRead(present);
        return false;
    }

    @Override
    public String toString() {
        return this.window.toString() + this.probation + this.protection;
    }

    private void drainRead(Lru.Node<Integer> node) {
        this.sketch.increment(node.getKey().hashCode());
        switch (node.getLru()) {
            case 1: {
                this.window.refresh(node);
                break;
            }
            case 2: {
                this.probation.remove(node);
                Lru.Node<Integer> evicted = this.protection.push(node);
                if (evicted == null) break;
                this.probation.push(evicted);
                break;
            }
            case 3: {
                this.protection.refresh(node);
                break;
            }
            default: {
                throw new IllegalStateException("The element of cache is not contained in any segment");
            }
        }
    }

    private void drainAdded(Lru.Node<Integer> node, IntConsumer evict) {
        Lru.Node<Integer> evicted;
        this.sketch.increment(node.getKey().hashCode());
        Lru.Node<Integer> windowEvict = this.window.push(node);
        if (windowEvict == null) {
            return;
        }
        Lru.Node<Integer> probationEvict = this.probation.nextEviction();
        if (probationEvict == null) {
            this.probation.push(windowEvict);
            return;
        }
        Lru.Node<Integer> node2 = evicted = this.sketch.frequency(windowEvict.getKey().hashCode()) > this.sketch.frequency(probationEvict.getKey().hashCode()) ? this.probation.push(windowEvict) : windowEvict;
        if (evicted == null) {
            return;
        }
        super.remove(evicted.getKey(), evicted);
        evict.accept(evicted.getValue());
    }
}

