/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.AbstractTransactionState;
import io.asyncer.r2dbc.mysql.ConnectionState;
import io.asyncer.r2dbc.mysql.ConsistentSnapshotEngine;
import io.asyncer.r2dbc.mysql.MySqlTransactionDefinition;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.TransactionDefinition;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;

final class StartTransactionState
extends AbstractTransactionState {
    private static final int LOCK_WAIT_TIMEOUT = 1;
    private static final int ISOLATION_LEVEL = 2;
    private static final int START_TRANSACTION = 4;
    private final long lockWaitTimeout;
    @Nullable
    private final IsolationLevel isolationLevel;

    private StartTransactionState(ConnectionState state, int tasks, List<String> statements, long lockWaitTimeout, @Nullable IsolationLevel level) {
        super(state, tasks, statements);
        this.lockWaitTimeout = lockWaitTimeout;
        this.isolationLevel = level;
    }

    @Override
    boolean cancelTasks() {
        if (this.state.isInTransaction()) {
            this.tasks = 4;
            return true;
        }
        return false;
    }

    @Override
    protected boolean process(int task, SynchronousSink<Void> sink) {
        switch (task) {
            case 1: {
                this.state.setCurrentLockWaitTimeout(this.lockWaitTimeout);
                return true;
            }
            case 2: {
                if (this.isolationLevel != null) {
                    this.state.setIsolationLevel(this.isolationLevel);
                }
                return true;
            }
            case 4: {
                sink.complete();
                return false;
            }
        }
        sink.error((Throwable)new IllegalStateException("Undefined transaction task: " + task + ", remain: " + this.tasks));
        return false;
    }

    static StartTransactionState of(ConnectionState state, TransactionDefinition definition) {
        long lockWaitTimeout;
        int tasks = 4;
        Duration timeout = (Duration)definition.getAttribute(TransactionDefinition.LOCK_WAIT_TIMEOUT);
        ArrayList<String> statements = null;
        if (timeout == null) {
            lockWaitTimeout = Long.MIN_VALUE;
        } else {
            lockWaitTimeout = timeout.getSeconds();
            statements = new ArrayList<String>(3);
            statements.add("SET innodb_lock_wait_timeout=" + lockWaitTimeout);
            tasks |= 1;
        }
        IsolationLevel isolationLevel = (IsolationLevel)definition.getAttribute(TransactionDefinition.ISOLATION_LEVEL);
        if (isolationLevel != null) {
            if (statements == null) {
                statements = new ArrayList(3);
            }
            statements.add("SET TRANSACTION ISOLATION LEVEL " + isolationLevel.asSql());
            tasks |= 2;
        }
        if (statements == null) {
            return new StartTransactionState(state, tasks, Collections.singletonList(StartTransactionState.buildStartTransaction(definition)), lockWaitTimeout, null);
        }
        statements.add(StartTransactionState.buildStartTransaction(definition));
        return new StartTransactionState(state, tasks, statements, lockWaitTimeout, isolationLevel);
    }

    private static String buildStartTransaction(TransactionDefinition definition) {
        Boolean readOnly = (Boolean)definition.getAttribute(TransactionDefinition.READ_ONLY);
        Boolean snapshot = (Boolean)definition.getAttribute(MySqlTransactionDefinition.WITH_CONSISTENT_SNAPSHOT);
        if (!(readOnly != null || snapshot != null && snapshot.booleanValue())) {
            return "BEGIN";
        }
        StringBuilder builder = new StringBuilder(90).append("START TRANSACTION");
        if (snapshot != null && snapshot.booleanValue()) {
            ConsistentSnapshotEngine engine = (ConsistentSnapshotEngine)((Object)definition.getAttribute(MySqlTransactionDefinition.CONSISTENT_SNAPSHOT_ENGINE));
            builder.append(" WITH CONSISTENT ");
            if (engine == null) {
                builder.append("SNAPSHOT");
            } else {
                builder.append(engine.asSql()).append(" SNAPSHOT");
            }
            Long sessionId = (Long)definition.getAttribute(MySqlTransactionDefinition.CONSISTENT_SNAPSHOT_FROM_SESSION);
            if (sessionId != null) {
                builder.append(" FROM SESSION ").append(Long.toUnsignedString(sessionId));
            }
        }
        if (readOnly != null) {
            if (readOnly.booleanValue()) {
                builder.append(" READ ONLY");
            } else {
                builder.append(" READ WRITE");
            }
        }
        return builder.toString();
    }
}

