/*
 * Decompiled with CFR 0.152.
 */
package arrow.integrations.jackson.module.internal;

import arrow.core.None;
import arrow.core.Option;
import arrow.core.Some;
import arrow.integrations.jackson.module.internal.ElementDeserializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.std.StdDeserializer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0018B%\bF\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u000f\u0010\u0003\u001a\u00020\u0004X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0084\b\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0084\b\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Larrow/integrations/jackson/module/internal/UnionTypeDeserializer;", "T", "Ltools/jackson/databind/deser/std/StdDeserializer;", "javaType", "Ltools/jackson/databind/JavaType;", "fields", "", "Larrow/integrations/jackson/module/internal/UnionTypeDeserializer$InjectField;", "<init>", "(Ltools/jackson/databind/JavaType;Ljava/util/List;)V", "deserializers", "", "", "Larrow/integrations/jackson/module/internal/ElementDeserializer;", "deserialize", "parser", "Ltools/jackson/core/JsonParser;", "ctxt", "Ltools/jackson/databind/DeserializationContext;", "(Ltools/jackson/core/JsonParser;Ltools/jackson/databind/DeserializationContext;)Ljava/lang/Object;", "createContextual", "Ltools/jackson/databind/ValueDeserializer;", "property", "Ltools/jackson/databind/BeanProperty;", "InjectField", "arrow-core-jackson"})
@SourceDebugExtension(value={"SMAP\nUnionTypeDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnionTypeDeserializer.kt\narrow/integrations/jackson/module/internal/UnionTypeDeserializer\n+ 2 Iterable.kt\narrow/core/IterableKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n664#2,6:56\n1586#3:62\n1661#3,3:63\n1924#3,3:66\n*S KotlinDebug\n*F\n+ 1 UnionTypeDeserializer.kt\narrow/integrations/jackson/module/internal/UnionTypeDeserializer\n*L\n21#1:56,6\n33#1:62\n33#1:63,3\n45#1:66,3\n*E\n"})
public final class UnionTypeDeserializer<T>
extends StdDeserializer<T> {
    @NotNull
    private final JavaType javaType;
    @NotNull
    private final List<InjectField<T>> fields;
    @NotNull
    private final Map<String, ElementDeserializer> deserializers;

    public UnionTypeDeserializer(@NotNull JavaType javaType, @NotNull List<InjectField<T>> fields) {
        Intrinsics.checkNotNullParameter((Object)javaType, (String)"javaType");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super(javaType);
        this.javaType = javaType;
        this.fields = fields;
        this.deserializers = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public T deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext ctxt) {
        Object object;
        Option field;
        block7: {
            Option option;
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
            parser.nextToken();
            Iterable $this$firstOrNone$iv = this.fields;
            boolean $i$f$firstOrNone = false;
            for (Object element$iv : $this$firstOrNone$iv) {
                InjectField it = (InjectField)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)parser.currentName(), (Object)it.getFieldName())) continue;
                option = (Option)new Some(element$iv);
                break block7;
            }
            option = field = (Option)None.INSTANCE;
        }
        if (field instanceof Some) {
            InjectField injectField = (InjectField)((Some)field).getValue();
            ElementDeserializer elementDeserializer = this.deserializers.get(injectField.getFieldName());
            if (elementDeserializer == null) {
                boolean $i$a$-requireNotNull-UnionTypeDeserializer$deserialize$elementDeserializer$22 = false;
                String $i$a$-requireNotNull-UnionTypeDeserializer$deserialize$elementDeserializer$22 = "unexpected deserializer not found";
                throw new IllegalArgumentException($i$a$-requireNotNull-UnionTypeDeserializer$deserialize$elementDeserializer$22.toString());
            }
            ElementDeserializer elementDeserializer2 = elementDeserializer;
            JsonToken jsonToken = parser.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)jsonToken, (String)"nextToken(...)");
            Object value = elementDeserializer2.deserialize(this.javaType, jsonToken, parser, ctxt);
            parser.nextToken();
            object = injectField.getPoint().invoke(value);
        } else if (field instanceof None) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.fields;
            boolean $i$f$map = false;
            Iterable $i$a$-requireNotNull-UnionTypeDeserializer$deserialize$elementDeserializer$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InjectField injectField = (InjectField)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFieldName());
            }
            List validFields = (List)destination$iv$iv;
            String message = "Cannot deserialize " + this.javaType + ". Make sure json fields are valid: " + validFields + ".";
            object = ctxt.handleUnexpectedToken(this.javaType, parser.currentToken(), parser, message, new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ValueDeserializer<?> createContextual(@NotNull DeserializationContext ctxt, @Nullable BeanProperty property) {
        UnionTypeDeserializer<T> unionTypeDeserializer;
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        UnionTypeDeserializer<T> deserializer = unionTypeDeserializer = new UnionTypeDeserializer<T>(this.javaType, this.fields);
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = this.fields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            InjectField injectField = (InjectField)item$iv;
            int index = n;
            boolean bl2 = false;
            Map<String, ElementDeserializer> map = deserializer.deserializers;
            String string = field.getFieldName();
            JavaType javaType = ctxt.getContextualType().containedTypeOrUnknown(index);
            Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"containedTypeOrUnknown(...)");
            ElementDeserializer elementDeserializer = ElementDeserializer.Companion.resolve(javaType, ctxt, property);
            map.put(string, elementDeserializer);
        }
        return (ValueDeserializer)unionTypeDeserializer;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B'\bF\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0015\u0010\u0003\u001a\u00020\u0004X\u0086\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u0005\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00028\u00010\u0006X\u0086\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Larrow/integrations/jackson/module/internal/UnionTypeDeserializer$InjectField;", "T", "", "fieldName", "", "point", "Lkotlin/Function1;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getFieldName", "()Ljava/lang/String;", "getPoint", "()Lkotlin/jvm/functions/Function1;", "arrow-core-jackson"})
    public static final class InjectField<T> {
        @NotNull
        private final String fieldName;
        @NotNull
        private final Function1<Object, T> point;

        public InjectField(@NotNull String fieldName, @NotNull Function1<Object, ? extends T> point) {
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter(point, (String)"point");
            this.fieldName = fieldName;
            this.point = point;
        }

        @NotNull
        public final String getFieldName() {
            return this.fieldName;
        }

        @NotNull
        public final Function1<Object, T> getPoint() {
            return this.point;
        }
    }
}

