/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.coreutils.internal.parsing;

import io.appmetrica.analytics.coreutils.internal.WrapUtils;
import io.appmetrica.analytics.coreutils.internal.parsing.JsonUtils;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001J \u0010\b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0004H\u0007J%\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J(\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a8\u0006\u0016"}, d2={"Lio/appmetrica/analytics/coreutils/internal/parsing/RemoteConfigJsonUtils;", "", "Lorg/json/JSONObject;", "input", "", "name", "", "fallback", "extractFeature", "key", "extractQuery", "type", "", "", "extractHosts", "(Lorg/json/JSONObject;Ljava/lang/String;)[[B", "", "defaultMillis", "extractMillisFromSecondsOrDefault", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "extractMillisOrDefault", "core-utils_release"})
public final class RemoteConfigJsonUtils {
    @NotNull
    public static final RemoteConfigJsonUtils INSTANCE = new RemoteConfigJsonUtils();

    private RemoteConfigJsonUtils() {
    }

    @JvmStatic
    public static final boolean extractFeature(@NotNull JSONObject jSONObject, @NotNull String string, boolean bl) {
        block5: {
            try {
                jSONObject = jSONObject.optJSONObject("features");
                if (jSONObject == null) break block5;
            }
            catch (Throwable throwable) {}
            jSONObject = jSONObject.optJSONObject("list");
            if (jSONObject == null) break block5;
            jSONObject = jSONObject.optJSONObject(string);
            if (jSONObject == null) break block5;
            return jSONObject.optBoolean("enabled", bl);
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final String extractQuery(@NotNull JSONObject object, @NotNull String string) {
        block9: {
            try {
                object = object.optJSONObject("queries");
                if (object == null) break block9;
            }
            catch (Throwable throwable) {}
            object = object.optJSONObject("list");
            if (object == null) break block9;
            object = object.optJSONObject(string);
            if (object == null) break block9;
            JSONObject jSONObject = object;
            object = INSTANCE;
            string = jSONObject.optString("url", "");
            object.getClass();
            if (Intrinsics.areEqual((Object)string, (Object)"")) {
                string = null;
            }
            return string;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final byte[][] extractHosts(@NotNull JSONObject jSONObject, @NotNull String string) {
        byte[][] byArrayArray;
        if ((jSONObject = jSONObject.optJSONObject("query_hosts")) != null && (jSONObject = jSONObject.optJSONObject("list")) != null && (jSONObject = jSONObject.optJSONObject(string)) != null && (jSONObject = jSONObject.optJSONArray("urls")) != null) {
            int n = jSONObject.length();
            byArrayArray = new byte[n][];
            for (int k = 0; k < n; ++k) {
                byArrayArray[k] = jSONObject.optString(k).getBytes(Charsets.UTF_8);
            }
        } else {
            byArrayArray = new byte[][]{};
        }
        return byArrayArray;
    }

    @JvmStatic
    public static final long extractMillisFromSecondsOrDefault(@NotNull JSONObject jSONObject, @NotNull String string, long l) {
        return RemoteConfigJsonUtils.extractMillisOrDefault(jSONObject, string, TimeUnit.SECONDS, l);
    }

    @JvmStatic
    public static final long extractMillisOrDefault(@NotNull JSONObject jSONObject, @NotNull String string, @NotNull TimeUnit timeUnit, long l) {
        return WrapUtils.getMillisOrDefault(JsonUtils.optLongOrNull(jSONObject, string), timeUnit, l);
    }
}

